/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.Vector;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.Switzerland;
import org.junit.Test;

public class SwitzerlandCalendarTest {
    public SwitzerlandCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testSwitzerlandSWXCalendar() {
        QL.info("\n\n=== Switzerland SWX Calendar ===");
        Switzerland c = new Switzerland();
        this.testSwitzerlandCalendar(c);
    }

    private void testSwitzerlandCalendar(Calendar c) {
        this.testSwitzerland2004(c);
        this.testSwitzerland2005(c);
        this.testSwitzerland2006(c);
        this.testSwitzerland2007(c);
        this.testSwitzerland2008(c);
        this.testSwitzerland2009(c);
        this.testSwitzerland2010(c);
        this.testSwitzerland2011(c);
        this.testSwitzerland2012(c);
    }

    public void testSwitzerland2004(Calendar c) {
        int year = 2004;
        QL.info("Testing " + c.name() + " holiday list for the year " + 2004 + "...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(2, Month.January, 2004));
        expectedHol.add(new Date(9, Month.April, 2004));
        expectedHol.add(new Date(12, Month.April, 2004));
        expectedHol.add(new Date(20, Month.May, 2004));
        expectedHol.add(new Date(31, Month.May, 2004));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, c, 2004);
    }

    public void testSwitzerland2005(Calendar c) {
        int year = 2005;
        QL.info("Testing " + c.name() + " holiday list for the year " + 2005 + "...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(25, Month.March, 2005));
        expectedHol.add(new Date(28, Month.March, 2005));
        expectedHol.add(new Date(5, Month.May, 2005));
        expectedHol.add(new Date(16, Month.May, 2005));
        expectedHol.add(new Date(1, Month.August, 2005));
        expectedHol.add(new Date(26, Month.December, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, c, 2005);
    }

    public void testSwitzerland2006(Calendar c) {
        int year = 2006;
        QL.info("Testing " + c.name() + " holiday list for the year " + 2006 + "...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(2, Month.January, 2006));
        expectedHol.add(new Date(14, Month.April, 2006));
        expectedHol.add(new Date(17, Month.April, 2006));
        expectedHol.add(new Date(1, Month.May, 2006));
        expectedHol.add(new Date(25, Month.May, 2006));
        expectedHol.add(new Date(5, Month.June, 2006));
        expectedHol.add(new Date(1, Month.August, 2006));
        expectedHol.add(new Date(25, Month.December, 2006));
        expectedHol.add(new Date(26, Month.December, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, c, 2006);
    }

    public void testSwitzerland2007(Calendar c) {
        int year = 2007;
        QL.info("Testing " + c.name() + " holiday list for the year " + 2007 + "...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(2, Month.January, 2007));
        expectedHol.add(new Date(6, Month.April, 2007));
        expectedHol.add(new Date(9, Month.April, 2007));
        expectedHol.add(new Date(1, Month.May, 2007));
        expectedHol.add(new Date(17, Month.May, 2007));
        expectedHol.add(new Date(28, Month.May, 2007));
        expectedHol.add(new Date(1, Month.August, 2007));
        expectedHol.add(new Date(25, Month.December, 2007));
        expectedHol.add(new Date(26, Month.December, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, c, 2007);
    }

    public void testSwitzerland2008(Calendar c) {
        int year = 2008;
        QL.info("Testing " + c.name() + " holiday list for the year " + 2008 + "...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(2, Month.January, 2008));
        expectedHol.add(new Date(21, Month.March, 2008));
        expectedHol.add(new Date(24, Month.March, 2008));
        expectedHol.add(new Date(1, Month.May, 2008));
        expectedHol.add(new Date(12, Month.May, 2008));
        expectedHol.add(new Date(1, Month.August, 2008));
        expectedHol.add(new Date(25, Month.December, 2008));
        expectedHol.add(new Date(26, Month.December, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, c, 2008);
    }

    public void testSwitzerland2009(Calendar c) {
        int year = 2009;
        QL.info("Testing " + c.name() + " holiday list for the year " + 2009 + "...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(2, Month.January, 2009));
        expectedHol.add(new Date(10, Month.April, 2009));
        expectedHol.add(new Date(13, Month.April, 2009));
        expectedHol.add(new Date(1, Month.May, 2009));
        expectedHol.add(new Date(21, Month.May, 2009));
        expectedHol.add(new Date(1, Month.June, 2009));
        expectedHol.add(new Date(25, Month.December, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, c, 2009);
    }

    public void testSwitzerland2010(Calendar c) {
        int year = 2010;
        QL.info("Testing " + c.name() + " holiday list for the year " + 2010 + "...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        expectedHol.add(new Date(2, Month.April, 2010));
        expectedHol.add(new Date(5, Month.April, 2010));
        expectedHol.add(new Date(13, Month.May, 2010));
        expectedHol.add(new Date(24, Month.May, 2010));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, c, 2010);
    }

    public void testSwitzerland2011(Calendar c) {
        int year = 2011;
        QL.info("Testing " + c.name() + " holiday list for the year " + 2011 + "...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(22, Month.April, 2011));
        expectedHol.add(new Date(25, Month.April, 2011));
        expectedHol.add(new Date(2, Month.June, 2011));
        expectedHol.add(new Date(13, Month.June, 2011));
        expectedHol.add(new Date(1, Month.August, 2011));
        expectedHol.add(new Date(26, Month.December, 2011));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, c, 2011);
    }

    public void testSwitzerland2012(Calendar c) {
        int year = 2012;
        QL.info("Testing " + c.name() + " holiday list for the year " + 2012 + "...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(2, Month.January, 2012));
        expectedHol.add(new Date(6, Month.April, 2012));
        expectedHol.add(new Date(9, Month.April, 2012));
        expectedHol.add(new Date(1, Month.May, 2012));
        expectedHol.add(new Date(17, Month.May, 2012));
        expectedHol.add(new Date(28, Month.May, 2012));
        expectedHol.add(new Date(1, Month.August, 2012));
        expectedHol.add(new Date(25, Month.December, 2012));
        expectedHol.add(new Date(26, Month.December, 2012));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, c, 2012);
    }
}

