/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.Germany;
import org.junit.Test;

public class GermanyCalendarTest {
    private final Calendar cFrankfurt;
    private final Calendar cXetra;
    private final Calendar cEurex;
    private final Calendar cSettlement;

    public GermanyCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.cSettlement = new Germany(Germany.Market.Settlement);
        this.cFrankfurt = new Germany(Germany.Market.FrankfurtStockExchange);
        this.cXetra = new Germany(Germany.Market.Xetra);
        this.cEurex = new Germany(Germany.Market.Eurex);
    }

    @Test
    public void testGermanyYear2004() {
        int year = 2004;
        QL.info("Testing Germany holiday list for the year 2004 as recognized by markets Frankfurt Stock Exchange, Xetra, Eurex ...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(24, Month.December, 2004));
        expectedHol.add(new Date(31, Month.December, 2004));
        expectedHol.add(new Date(9, Month.April, 2004));
        expectedHol.add(new Date(12, Month.April, 2004));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cFrankfurt, 2004);
        cbt.checkHolidayList(expectedHol, this.cXetra, 2004);
        cbt.checkHolidayList(expectedHol, this.cEurex, 2004);
        QL.info("Testing Germany holiday list for the year 2004 as recognized by Settlement ...");
        expectedHol.add(new Date(20, Month.May, 2004));
        expectedHol.add(new Date(31, Month.May, 2004));
        expectedHol.add(new Date(10, Month.June, 2004));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2004);
    }

    @Test
    public void testGermanyYear2005() {
        int year = 2005;
        QL.info("Testing Germany holiday list for the year 2005 as recognized by markets Frankfurt Stock Exchange, Xetra, Eurex ...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(26, Month.December, 2005));
        expectedHol.add(new Date(25, Month.March, 2005));
        expectedHol.add(new Date(28, Month.March, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cFrankfurt, 2005);
        cbt.checkHolidayList(expectedHol, this.cXetra, 2005);
        cbt.checkHolidayList(expectedHol, this.cEurex, 2005);
        QL.info("Testing Germany holiday list for the year 2005 as recognized by Settlement ...");
        expectedHol.add(new Date(3, Month.October, 2005));
        expectedHol.add(new Date(5, Month.May, 2005));
        expectedHol.add(new Date(16, Month.May, 2005));
        expectedHol.add(new Date(26, Month.May, 2005));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2005);
    }

    @Test
    public void testGermanyYear2006() {
        int year = 2006;
        QL.info("Testing Germany holiday list for the year 2006 as recognized by markets Frankfurt Stock Exchange, Xetra, Eurex ...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.May, 2006));
        expectedHol.add(new Date(25, Month.December, 2006));
        expectedHol.add(new Date(26, Month.December, 2006));
        expectedHol.add(new Date(14, Month.April, 2006));
        expectedHol.add(new Date(17, Month.April, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cFrankfurt, 2006);
        cbt.checkHolidayList(expectedHol, this.cXetra, 2006);
        cbt.checkHolidayList(expectedHol, this.cEurex, 2006);
        QL.info("Testing Germany holiday list for the year 2006 as recognized by Settlement ...");
        expectedHol.add(new Date(3, Month.October, 2006));
        expectedHol.add(new Date(25, Month.May, 2006));
        expectedHol.add(new Date(5, Month.June, 2006));
        expectedHol.add(new Date(15, Month.June, 2006));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2006);
    }

    @Test
    public void testGermanyYear2007() {
        int year = 2007;
        QL.info("Testing Germany holiday list for the year 2007 as recognized by markets Frankfurt Stock Exchange, Xetra, Eurex ...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(1, Month.May, 2007));
        expectedHol.add(new Date(24, Month.December, 2007));
        expectedHol.add(new Date(25, Month.December, 2007));
        expectedHol.add(new Date(26, Month.December, 2007));
        expectedHol.add(new Date(31, Month.December, 2007));
        expectedHol.add(new Date(6, Month.April, 2007));
        expectedHol.add(new Date(9, Month.April, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cFrankfurt, 2007);
        cbt.checkHolidayList(expectedHol, this.cXetra, 2007);
        cbt.checkHolidayList(expectedHol, this.cEurex, 2007);
        QL.info("Testing Germany holiday list for the year 2007 as recognized by Settlement ...");
        expectedHol.add(new Date(3, Month.October, 2007));
        expectedHol.add(new Date(17, Month.May, 2007));
        expectedHol.add(new Date(28, Month.May, 2007));
        expectedHol.add(new Date(7, Month.June, 2007));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2007);
    }

    @Test
    public void testGermanyYear2008() {
        int year = 2008;
        QL.info("Testing Germany holiday list for the year 2008 as recognized by markets Frankfurt Stock Exchange, Xetra, Eurex ...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(1, Month.May, 2008));
        expectedHol.add(new Date(24, Month.December, 2008));
        expectedHol.add(new Date(25, Month.December, 2008));
        expectedHol.add(new Date(26, Month.December, 2008));
        expectedHol.add(new Date(31, Month.December, 2008));
        expectedHol.add(new Date(21, Month.March, 2008));
        expectedHol.add(new Date(24, Month.March, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cFrankfurt, 2008);
        cbt.checkHolidayList(expectedHol, this.cXetra, 2008);
        cbt.checkHolidayList(expectedHol, this.cEurex, 2008);
        QL.info("Testing Germany holiday list for the year 2008 as recognized by Settlement ...");
        expectedHol.add(new Date(3, Month.October, 2008));
        expectedHol.add(new Date(12, Month.May, 2008));
        expectedHol.add(new Date(22, Month.May, 2008));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2008);
    }

    @Test
    public void testGermanyYear2009() {
        int year = 2009;
        QL.info("Testing Germany holiday list for the year 2009 as recognized by markets Frankfurt Stock Exchange, Xetra, Eurex ...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(1, Month.May, 2009));
        expectedHol.add(new Date(24, Month.December, 2009));
        expectedHol.add(new Date(25, Month.December, 2009));
        expectedHol.add(new Date(31, Month.December, 2009));
        expectedHol.add(new Date(10, Month.April, 2009));
        expectedHol.add(new Date(13, Month.April, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cFrankfurt, 2009);
        cbt.checkHolidayList(expectedHol, this.cXetra, 2009);
        cbt.checkHolidayList(expectedHol, this.cEurex, 2009);
        QL.info("Testing Germany holiday list for the year 2009 as recognized by Settlement ...");
        expectedHol.add(new Date(21, Month.May, 2009));
        expectedHol.add(new Date(1, Month.June, 2009));
        expectedHol.add(new Date(11, Month.June, 2009));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2009);
    }

    @Test
    public void testGermanyYear2010() {
        int year = 2010;
        QL.info("Testing Germany holiday list for the year 2010 as recognized by markets Frankfurt Stock Exchange, Xetra, Eurex ...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        expectedHol.add(new Date(24, Month.December, 2010));
        expectedHol.add(new Date(31, Month.December, 2010));
        expectedHol.add(new Date(2, Month.April, 2010));
        expectedHol.add(new Date(5, Month.April, 2010));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cFrankfurt, 2010);
        cbt.checkHolidayList(expectedHol, this.cXetra, 2010);
        cbt.checkHolidayList(expectedHol, this.cEurex, 2010);
        QL.info("Testing Germany holiday list for the year 2010 as recognized by Settlement ...");
        expectedHol.add(new Date(13, Month.May, 2010));
        expectedHol.add(new Date(24, Month.May, 2010));
        expectedHol.add(new Date(3, Month.June, 2010));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2010);
    }

    @Test
    public void testGermanyYear2011() {
        int year = 2011;
        QL.info("Testing Germany holiday list for the year 2011 as recognized by markets Frankfurt Stock Exchange, Xetra, Eurex ...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(26, Month.December, 2011));
        expectedHol.add(new Date(22, Month.April, 2011));
        expectedHol.add(new Date(25, Month.April, 2011));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cFrankfurt, 2011);
        cbt.checkHolidayList(expectedHol, this.cXetra, 2011);
        cbt.checkHolidayList(expectedHol, this.cEurex, 2011);
        QL.info("Testing Germany holiday list for the year 2011 as recognized by Settlement ...");
        expectedHol.add(new Date(3, Month.October, 2011));
        expectedHol.add(new Date(2, Month.June, 2011));
        expectedHol.add(new Date(13, Month.June, 2011));
        expectedHol.add(new Date(23, Month.June, 2011));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2011);
    }

    @Test
    public void testGermanyYear2012() {
        int year = 2012;
        QL.info("Testing Germany holiday list for the year 2012 as recognized by markets Frankfurt Stock Exchange, Xetra, Eurex ...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.May, 2012));
        expectedHol.add(new Date(24, Month.December, 2012));
        expectedHol.add(new Date(25, Month.December, 2012));
        expectedHol.add(new Date(26, Month.December, 2012));
        expectedHol.add(new Date(31, Month.December, 2012));
        expectedHol.add(new Date(6, Month.April, 2012));
        expectedHol.add(new Date(9, Month.April, 2012));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cFrankfurt, 2012);
        cbt.checkHolidayList(expectedHol, this.cXetra, 2012);
        cbt.checkHolidayList(expectedHol, this.cEurex, 2012);
        QL.info("Testing Germany holiday list for the year 2012 as recognized by Settlement ...");
        expectedHol.add(new Date(3, Month.October, 2012));
        expectedHol.add(new Date(17, Month.May, 2012));
        expectedHol.add(new Date(28, Month.May, 2012));
        expectedHol.add(new Date(7, Month.June, 2012));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2012);
    }
}

