/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.CzechRepublic;
import org.junit.Test;

public class CzechRepublicCalendarTest {
    private final Calendar c;

    public CzechRepublicCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.c = new CzechRepublic(CzechRepublic.Market.PSE);
    }

    @Test
    public void testCzechRepublicPSEHolidaysYear2004() {
        int year = 2004;
        QL.info("Testing " + (Object)((Object)CzechRepublic.Market.PSE) + " holidays list for the year " + 2004 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(2, Month.January, 2004));
        expectedHol.add(new Date(12, Month.April, 2004));
        expectedHol.add(new Date(5, Month.July, 2004));
        expectedHol.add(new Date(6, Month.July, 2004));
        expectedHol.add(new Date(28, Month.September, 2004));
        expectedHol.add(new Date(28, Month.October, 2004));
        expectedHol.add(new Date(17, Month.November, 2004));
        expectedHol.add(new Date(24, Month.December, 2004));
        expectedHol.add(new Date(31, Month.December, 2004));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2004);
    }

    @Test
    public void testCzechRepublicPSEHolidaysYear2005() {
        int year = 2005;
        QL.info("Testing " + (Object)((Object)CzechRepublic.Market.PSE) + " holidays list for the year " + 2005 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(28, Month.March, 2005));
        expectedHol.add(new Date(5, Month.July, 2005));
        expectedHol.add(new Date(6, Month.July, 2005));
        expectedHol.add(new Date(28, Month.September, 2005));
        expectedHol.add(new Date(28, Month.October, 2005));
        expectedHol.add(new Date(17, Month.November, 2005));
        expectedHol.add(new Date(26, Month.December, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2005);
    }

    @Test
    public void testCzechRepublicPSEHolidaysYear2006() {
        int year = 2006;
        QL.info("Testing " + (Object)((Object)CzechRepublic.Market.PSE) + " holidays list for the year " + 2006 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(17, Month.April, 2006));
        expectedHol.add(new Date(1, Month.May, 2006));
        expectedHol.add(new Date(8, Month.May, 2006));
        expectedHol.add(new Date(5, Month.July, 2006));
        expectedHol.add(new Date(6, Month.July, 2006));
        expectedHol.add(new Date(28, Month.September, 2006));
        expectedHol.add(new Date(17, Month.November, 2006));
        expectedHol.add(new Date(25, Month.December, 2006));
        expectedHol.add(new Date(26, Month.December, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2006);
    }

    @Test
    public void testCzechRepublicPSEHolidaysYear2007() {
        int year = 2007;
        QL.info("Testing " + (Object)((Object)CzechRepublic.Market.PSE) + " holidays list for the year " + 2007 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(9, Month.April, 2007));
        expectedHol.add(new Date(1, Month.May, 2007));
        expectedHol.add(new Date(8, Month.May, 2007));
        expectedHol.add(new Date(5, Month.July, 2007));
        expectedHol.add(new Date(6, Month.July, 2007));
        expectedHol.add(new Date(28, Month.September, 2007));
        expectedHol.add(new Date(24, Month.December, 2007));
        expectedHol.add(new Date(25, Month.December, 2007));
        expectedHol.add(new Date(26, Month.December, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2007);
    }

    @Test
    public void testCzechRepublicPSEHolidaysYear2008() {
        int year = 2008;
        QL.info("Testing " + (Object)((Object)CzechRepublic.Market.PSE) + " holidays list for the year " + 2008 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(24, Month.March, 2008));
        expectedHol.add(new Date(1, Month.May, 2008));
        expectedHol.add(new Date(8, Month.May, 2008));
        expectedHol.add(new Date(28, Month.October, 2008));
        expectedHol.add(new Date(17, Month.November, 2008));
        expectedHol.add(new Date(24, Month.December, 2008));
        expectedHol.add(new Date(25, Month.December, 2008));
        expectedHol.add(new Date(26, Month.December, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2008);
    }

    @Test
    public void testCzechRepublicPSEHolidaysYear2009() {
        int year = 2009;
        QL.info("Testing " + (Object)((Object)CzechRepublic.Market.PSE) + " holidays list for the year " + 2009 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(13, Month.April, 2009));
        expectedHol.add(new Date(1, Month.May, 2009));
        expectedHol.add(new Date(8, Month.May, 2009));
        expectedHol.add(new Date(6, Month.July, 2009));
        expectedHol.add(new Date(28, Month.September, 2009));
        expectedHol.add(new Date(28, Month.October, 2009));
        expectedHol.add(new Date(17, Month.November, 2009));
        expectedHol.add(new Date(24, Month.December, 2009));
        expectedHol.add(new Date(25, Month.December, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2009);
    }

    @Test
    public void testCzechRepublicPSEHolidaysYear2010() {
        int year = 2010;
        QL.info("Testing " + (Object)((Object)CzechRepublic.Market.PSE) + " holidays list for the year " + 2010 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        expectedHol.add(new Date(5, Month.April, 2010));
        expectedHol.add(new Date(5, Month.July, 2010));
        expectedHol.add(new Date(6, Month.July, 2010));
        expectedHol.add(new Date(28, Month.September, 2010));
        expectedHol.add(new Date(28, Month.October, 2010));
        expectedHol.add(new Date(17, Month.November, 2010));
        expectedHol.add(new Date(24, Month.December, 2010));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2010);
    }

    @Test
    public void testCzechRepublicPSEHolidaysYear2011() {
        int year = 2011;
        QL.info("Testing " + (Object)((Object)CzechRepublic.Market.PSE) + " holidays list for the year " + 2011 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(25, Month.April, 2011));
        expectedHol.add(new Date(5, Month.July, 2011));
        expectedHol.add(new Date(6, Month.July, 2011));
        expectedHol.add(new Date(28, Month.September, 2011));
        expectedHol.add(new Date(28, Month.October, 2011));
        expectedHol.add(new Date(17, Month.November, 2011));
        expectedHol.add(new Date(26, Month.December, 2011));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2011);
    }

    @Test
    public void testCzechRepublicPSEHolidaysYear2012() {
        int year = 2012;
        QL.info("Testing " + (Object)((Object)CzechRepublic.Market.PSE) + " holidays list for the year " + 2012 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(9, Month.April, 2012));
        expectedHol.add(new Date(1, Month.May, 2012));
        expectedHol.add(new Date(8, Month.May, 2012));
        expectedHol.add(new Date(5, Month.July, 2012));
        expectedHol.add(new Date(6, Month.July, 2012));
        expectedHol.add(new Date(28, Month.September, 2012));
        expectedHol.add(new Date(24, Month.December, 2012));
        expectedHol.add(new Date(25, Month.December, 2012));
        expectedHol.add(new Date(26, Month.December, 2012));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2012);
    }
}

