/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.China;
import org.junit.Test;

public class ChinaCalendarTest {
    private final Calendar exchange;

    public ChinaCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.exchange = new China(China.Market.SSE);
    }

    @Test
    public void testChinaSSEYear2004() {
        int year = 2004;
        QL.info("Testing China holiday list for the year 2004...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(19, Month.January, 2004));
        expectedHol.add(new Date(20, Month.January, 2004));
        expectedHol.add(new Date(21, Month.January, 2004));
        expectedHol.add(new Date(22, Month.January, 2004));
        expectedHol.add(new Date(23, Month.January, 2004));
        expectedHol.add(new Date(26, Month.January, 2004));
        expectedHol.add(new Date(27, Month.January, 2004));
        expectedHol.add(new Date(28, Month.January, 2004));
        expectedHol.add(new Date(3, Month.May, 2004));
        expectedHol.add(new Date(4, Month.May, 2004));
        expectedHol.add(new Date(5, Month.May, 2004));
        expectedHol.add(new Date(6, Month.May, 2004));
        expectedHol.add(new Date(7, Month.May, 2004));
        expectedHol.add(new Date(1, Month.October, 2004));
        expectedHol.add(new Date(4, Month.October, 2004));
        expectedHol.add(new Date(5, Month.October, 2004));
        expectedHol.add(new Date(6, Month.October, 2004));
        expectedHol.add(new Date(7, Month.October, 2004));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2004);
    }

    @Test
    public void testChinaSSEYear2005() {
        int year = 2005;
        QL.info("Testing China holiday list for the year 2005...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(3, Month.January, 2005));
        expectedHol.add(new Date(7, Month.February, 2005));
        expectedHol.add(new Date(8, Month.February, 2005));
        expectedHol.add(new Date(9, Month.February, 2005));
        expectedHol.add(new Date(10, Month.February, 2005));
        expectedHol.add(new Date(11, Month.February, 2005));
        expectedHol.add(new Date(14, Month.February, 2005));
        expectedHol.add(new Date(15, Month.February, 2005));
        expectedHol.add(new Date(2, Month.May, 2005));
        expectedHol.add(new Date(3, Month.May, 2005));
        expectedHol.add(new Date(4, Month.May, 2005));
        expectedHol.add(new Date(5, Month.May, 2005));
        expectedHol.add(new Date(6, Month.May, 2005));
        expectedHol.add(new Date(3, Month.October, 2005));
        expectedHol.add(new Date(4, Month.October, 2005));
        expectedHol.add(new Date(5, Month.October, 2005));
        expectedHol.add(new Date(6, Month.October, 2005));
        expectedHol.add(new Date(7, Month.October, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2005);
    }

    @Test
    public void testChinaSSEYear2006() {
        int year = 2006;
        QL.info("Testing China holiday list for the year 2006...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(2, Month.January, 2006));
        expectedHol.add(new Date(3, Month.January, 2006));
        expectedHol.add(new Date(26, Month.January, 2006));
        expectedHol.add(new Date(27, Month.January, 2006));
        expectedHol.add(new Date(30, Month.January, 2006));
        expectedHol.add(new Date(31, Month.January, 2006));
        expectedHol.add(new Date(1, Month.February, 2006));
        expectedHol.add(new Date(2, Month.February, 2006));
        expectedHol.add(new Date(3, Month.February, 2006));
        expectedHol.add(new Date(1, Month.May, 2006));
        expectedHol.add(new Date(2, Month.May, 2006));
        expectedHol.add(new Date(3, Month.May, 2006));
        expectedHol.add(new Date(4, Month.May, 2006));
        expectedHol.add(new Date(5, Month.May, 2006));
        expectedHol.add(new Date(2, Month.October, 2006));
        expectedHol.add(new Date(3, Month.October, 2006));
        expectedHol.add(new Date(4, Month.October, 2006));
        expectedHol.add(new Date(5, Month.October, 2006));
        expectedHol.add(new Date(6, Month.October, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2006);
    }

    @Test
    public void testChinaSSEYear2007() {
        int year = 2007;
        QL.info("Testing China holiday list for the year 2007...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(2, Month.January, 2007));
        expectedHol.add(new Date(3, Month.January, 2007));
        expectedHol.add(new Date(19, Month.February, 2007));
        expectedHol.add(new Date(20, Month.February, 2007));
        expectedHol.add(new Date(21, Month.February, 2007));
        expectedHol.add(new Date(22, Month.February, 2007));
        expectedHol.add(new Date(23, Month.February, 2007));
        expectedHol.add(new Date(1, Month.May, 2007));
        expectedHol.add(new Date(2, Month.May, 2007));
        expectedHol.add(new Date(3, Month.May, 2007));
        expectedHol.add(new Date(4, Month.May, 2007));
        expectedHol.add(new Date(7, Month.May, 2007));
        expectedHol.add(new Date(1, Month.October, 2007));
        expectedHol.add(new Date(2, Month.October, 2007));
        expectedHol.add(new Date(3, Month.October, 2007));
        expectedHol.add(new Date(4, Month.October, 2007));
        expectedHol.add(new Date(5, Month.October, 2007));
        expectedHol.add(new Date(31, Month.December, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2007);
    }

    @Test
    public void testChinaSSEYear2008() {
        int year = 2008;
        QL.info("Testing China holiday list for the year 2008...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(6, Month.February, 2008));
        expectedHol.add(new Date(7, Month.February, 2008));
        expectedHol.add(new Date(8, Month.February, 2008));
        expectedHol.add(new Date(11, Month.February, 2008));
        expectedHol.add(new Date(12, Month.February, 2008));
        expectedHol.add(new Date(4, Month.April, 2008));
        expectedHol.add(new Date(1, Month.May, 2008));
        expectedHol.add(new Date(2, Month.May, 2008));
        expectedHol.add(new Date(9, Month.June, 2008));
        expectedHol.add(new Date(15, Month.September, 2008));
        expectedHol.add(new Date(29, Month.September, 2008));
        expectedHol.add(new Date(30, Month.September, 2008));
        expectedHol.add(new Date(1, Month.October, 2008));
        expectedHol.add(new Date(2, Month.October, 2008));
        expectedHol.add(new Date(3, Month.October, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2008);
    }

    @Test
    public void testChinaSSEYear2009() {
        int year = 2009;
        QL.info("Testing China holiday list for the year 2009...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(2, Month.January, 2009));
        expectedHol.add(new Date(26, Month.January, 2009));
        expectedHol.add(new Date(27, Month.January, 2009));
        expectedHol.add(new Date(28, Month.January, 2009));
        expectedHol.add(new Date(29, Month.January, 2009));
        expectedHol.add(new Date(30, Month.January, 2009));
        expectedHol.add(new Date(6, Month.April, 2009));
        expectedHol.add(new Date(1, Month.May, 2009));
        expectedHol.add(new Date(28, Month.May, 2009));
        expectedHol.add(new Date(29, Month.May, 2009));
        expectedHol.add(new Date(1, Month.October, 2009));
        expectedHol.add(new Date(2, Month.October, 2009));
        expectedHol.add(new Date(5, Month.October, 2009));
        expectedHol.add(new Date(6, Month.October, 2009));
        expectedHol.add(new Date(7, Month.October, 2009));
        expectedHol.add(new Date(8, Month.October, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2009);
    }

    @Test
    public void testChinaSSEYear2010() {
        int year = 2010;
        QL.info("Testing China holiday list for the year 2010...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2010);
    }

    @Test
    public void testChinaSSEYear2011() {
        int year = 2011;
        QL.info("Testing China holiday list for the year 2011...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2011);
    }

    @Test
    public void testChinaSSEYear2012() {
        int year = 2012;
        QL.info("Testing China holiday list for the year 2012...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2012);
    }
}

