/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.Argentina;
import org.junit.Test;

public class ArgentinaCalendarTest {
    private final Calendar merval;

    public ArgentinaCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.merval = new Argentina(Argentina.Market.MERVAL);
    }

    @Test
    public void testArgentinaMervalYear2004() {
        int year = 2004;
        QL.info("Testing " + (Object)((Object)Argentina.Market.MERVAL) + " holiday list for the year " + 2004 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(8, Month.April, 2004));
        expectedHol.add(new Date(9, Month.April, 2004));
        expectedHol.add(new Date(25, Month.May, 2004));
        expectedHol.add(new Date(21, Month.June, 2004));
        expectedHol.add(new Date(9, Month.July, 2004));
        expectedHol.add(new Date(16, Month.August, 2004));
        expectedHol.add(new Date(11, Month.October, 2004));
        expectedHol.add(new Date(8, Month.December, 2004));
        expectedHol.add(new Date(24, Month.December, 2004));
        expectedHol.add(new Date(31, Month.December, 2004));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.merval, 2004);
    }

    @Test
    public void testArgentinaMervalYear2005() {
        int year = 2005;
        QL.info("Testing " + (Object)((Object)Argentina.Market.MERVAL) + " holiday list for the year " + 2005 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(24, Month.March, 2005));
        expectedHol.add(new Date(25, Month.March, 2005));
        expectedHol.add(new Date(25, Month.May, 2005));
        expectedHol.add(new Date(20, Month.June, 2005));
        expectedHol.add(new Date(15, Month.August, 2005));
        expectedHol.add(new Date(10, Month.October, 2005));
        expectedHol.add(new Date(8, Month.December, 2005));
        expectedHol.add(new Date(30, Month.December, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.merval, 2005);
    }

    @Test
    public void testArgentinaMervalYear2006() {
        int year = 2006;
        QL.info("Testing " + (Object)((Object)Argentina.Market.MERVAL) + " holiday list for the year " + 2006 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(13, Month.April, 2006));
        expectedHol.add(new Date(14, Month.April, 2006));
        expectedHol.add(new Date(1, Month.May, 2006));
        expectedHol.add(new Date(25, Month.May, 2006));
        expectedHol.add(new Date(19, Month.June, 2006));
        expectedHol.add(new Date(21, Month.August, 2006));
        expectedHol.add(new Date(16, Month.October, 2006));
        expectedHol.add(new Date(8, Month.December, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.merval, 2006);
    }

    @Test
    public void testArgentinaMervalYear2007() {
        int year = 2007;
        QL.info("Testing " + (Object)((Object)Argentina.Market.MERVAL) + " holiday list for the year " + 2007 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(5, Month.April, 2007));
        expectedHol.add(new Date(6, Month.April, 2007));
        expectedHol.add(new Date(1, Month.May, 2007));
        expectedHol.add(new Date(25, Month.May, 2007));
        expectedHol.add(new Date(18, Month.June, 2007));
        expectedHol.add(new Date(9, Month.July, 2007));
        expectedHol.add(new Date(20, Month.August, 2007));
        expectedHol.add(new Date(15, Month.October, 2007));
        expectedHol.add(new Date(20, Month.August, 2007));
        expectedHol.add(new Date(24, Month.December, 2007));
        expectedHol.add(new Date(31, Month.December, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.merval, 2007);
    }

    @Test
    public void testArgentinaMervalYear2008() {
        int year = 2008;
        QL.info("Testing " + (Object)((Object)Argentina.Market.MERVAL) + " holiday list for the year " + 2008 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(20, Month.March, 2008));
        expectedHol.add(new Date(21, Month.March, 2008));
        expectedHol.add(new Date(1, Month.May, 2008));
        expectedHol.add(new Date(16, Month.June, 2008));
        expectedHol.add(new Date(9, Month.July, 2008));
        expectedHol.add(new Date(18, Month.August, 2008));
        expectedHol.add(new Date(8, Month.December, 2008));
        expectedHol.add(new Date(24, Month.December, 2008));
        expectedHol.add(new Date(31, Month.December, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.merval, 2008);
    }

    @Test
    public void testArgentinaMervalYear2009() {
        int year = 2009;
        QL.info("Testing " + (Object)((Object)Argentina.Market.MERVAL) + " holiday list for the year " + 2009 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(9, Month.April, 2009));
        expectedHol.add(new Date(10, Month.April, 2009));
        expectedHol.add(new Date(1, Month.May, 2009));
        expectedHol.add(new Date(25, Month.May, 2009));
        expectedHol.add(new Date(15, Month.June, 2009));
        expectedHol.add(new Date(9, Month.July, 2009));
        expectedHol.add(new Date(17, Month.August, 2009));
        expectedHol.add(new Date(12, Month.October, 2009));
        expectedHol.add(new Date(8, Month.December, 2009));
        expectedHol.add(new Date(24, Month.December, 2009));
        expectedHol.add(new Date(31, Month.December, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.merval, 2009);
    }

    @Test
    public void testArgentinaMervalYear2010() {
        int year = 2010;
        QL.info("Testing " + (Object)((Object)Argentina.Market.MERVAL) + " holiday list for the year " + 2010 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        expectedHol.add(new Date(1, Month.April, 2010));
        expectedHol.add(new Date(2, Month.April, 2010));
        expectedHol.add(new Date(25, Month.May, 2010));
        expectedHol.add(new Date(21, Month.June, 2010));
        expectedHol.add(new Date(9, Month.July, 2010));
        expectedHol.add(new Date(16, Month.August, 2010));
        expectedHol.add(new Date(11, Month.October, 2010));
        expectedHol.add(new Date(8, Month.December, 2010));
        expectedHol.add(new Date(24, Month.December, 2010));
        expectedHol.add(new Date(31, Month.December, 2010));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.merval, 2010);
    }

    @Test
    public void testArgentinaMervalYear2011() {
        int year = 2011;
        QL.info("Testing " + (Object)((Object)Argentina.Market.MERVAL) + " holiday list for the year " + 2011 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(21, Month.April, 2011));
        expectedHol.add(new Date(22, Month.April, 2011));
        expectedHol.add(new Date(25, Month.May, 2011));
        expectedHol.add(new Date(20, Month.June, 2011));
        expectedHol.add(new Date(15, Month.August, 2011));
        expectedHol.add(new Date(10, Month.October, 2011));
        expectedHol.add(new Date(8, Month.December, 2011));
        expectedHol.add(new Date(30, Month.December, 2011));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.merval, 2011);
    }

    @Test
    public void testArgentinaMervalYear2012() {
        int year = 2012;
        QL.info("Testing " + (Object)((Object)Argentina.Market.MERVAL) + " holiday list for the year " + 2012 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(5, Month.April, 2012));
        expectedHol.add(new Date(6, Month.April, 2012));
        expectedHol.add(new Date(1, Month.May, 2012));
        expectedHol.add(new Date(25, Month.May, 2012));
        expectedHol.add(new Date(18, Month.June, 2012));
        expectedHol.add(new Date(9, Month.July, 2012));
        expectedHol.add(new Date(20, Month.August, 2012));
        expectedHol.add(new Date(15, Month.October, 2012));
        expectedHol.add(new Date(24, Month.December, 2012));
        expectedHol.add(new Date(31, Month.December, 2012));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.merval, 2012);
    }
}

