/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.InterestRate;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.ZeroYieldStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;

public class ZeroSpreadedTermStructure
extends ZeroYieldStructure {
    private final Handle<YieldTermStructure> originalCurve;
    private final Handle<Quote> spread;
    private final Compounding comp;
    private final Frequency freq;

    public ZeroSpreadedTermStructure(Handle<YieldTermStructure> h, Handle<Quote> spread, Compounding comp, Frequency freq, DayCounter dc) {
        QL.validateExperimentalMode();
        this.originalCurve = h;
        this.spread = spread;
        this.comp = comp;
        this.freq = freq;
        this.originalCurve.addObserver(this);
        this.spread.addObserver(this);
    }

    public double forwardImpl(double t) {
        return this.originalCurve.currentLink().forwardRate(t, t, this.comp, this.freq, true).rate() + this.spread.currentLink().value();
    }

    @Override
    protected double zeroYieldImpl(double t) {
        InterestRate zeroRate = this.originalCurve.currentLink().zeroRate(t, this.comp, this.freq, true);
        InterestRate spreadedRate = new InterestRate(zeroRate.rate() + this.spread.currentLink().value(), zeroRate.dayCounter(), zeroRate.compounding(), zeroRate.frequency());
        return spreadedRate.equivalentRate(t, Compounding.Continuous, Frequency.NoFrequency).rate();
    }

    @Override
    public Calendar calendar() {
        return this.originalCurve.currentLink().calendar();
    }

    @Override
    public Date referenceDate() {
        return this.originalCurve.currentLink().referenceDate();
    }

    @Override
    public Date maxDate() {
        return this.originalCurve.currentLink().maxDate();
    }

    @Override
    public double maxTime() {
        return this.originalCurve.currentLink().maxTime();
    }
}

