/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.termstructures.AbstractYieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.Traits;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.util.Pair;

public class InterpolatedDiscountCurve<I extends Interpolation.Interpolator>
extends AbstractYieldTermStructure
implements Traits.Curve {
    private Date[] dates;
    private double[] times;
    private Interpolation interpolation;
    private double[] data;
    private final Class<I> classI;
    private final Interpolation.Interpolator interpolator;

    public InterpolatedDiscountCurve(Class<I> classI, Date[] dates, double[] discounts, DayCounter dc) {
        this(classI, dates, discounts, dc, null, null);
    }

    public InterpolatedDiscountCurve(Class<I> classI, Date[] dates, double[] discounts, DayCounter dc, Calendar calendar) {
        this(classI, dates, discounts, dc, calendar, null);
    }

    public InterpolatedDiscountCurve(Class<I> classI, Date[] dates, double[] discounts, DayCounter dc, Calendar calendar, Interpolation.Interpolator interpolator) {
        super(dates[0], calendar == null ? new Calendar() : calendar, dc);
        QL.validateExperimentalMode();
        QL.require(classI != null, "Generic type for Interpolation is null");
        this.classI = classI;
        QL.require(dates.length != 0, "Dates cannot be empty");
        QL.require(discounts.length != 0, "Discounts cannot be empty");
        QL.require(dates.length == discounts.length, "Dates must be the same size as Discounts");
        QL.require(discounts[0] == 1.0, "Initial discount factor must be 1.0");
        this.dates = dates;
        this.data = discounts;
        this.times = new double[dates.length];
        this.times[0] = 0.0;
        for (int i = 1; i < dates.length; ++i) {
            QL.require(dates[i].gt(dates[i - 1]), "Dates must be in ascending order");
            QL.require(this.data[0] > 0.0, "Negative discount");
            this.times[i] = dc.yearFraction(dates[0], dates[i]);
            QL.require(Closeness.isClose(this.times[i], this.times[i - 1]), "two dates correspond to the same time under this curve's day count convention");
        }
        this.interpolator = interpolator == null ? InterpolatedDiscountCurve.constructInterpolator(classI) : interpolator;
        this.interpolation = this.interpolator.interpolate(new Array(this.times), new Array(this.data));
        this.interpolation.update();
    }

    protected InterpolatedDiscountCurve(Class<I> classI, DayCounter dc) {
        this(classI, dc, null);
    }

    protected InterpolatedDiscountCurve(Class<I> classI, DayCounter dc, Interpolation.Interpolator interpolator) {
        super(dc);
        QL.validateExperimentalMode();
        this.classI = classI;
        this.interpolator = interpolator == null ? InterpolatedDiscountCurve.constructInterpolator(classI) : interpolator;
    }

    protected InterpolatedDiscountCurve(Class<I> classI, Date referenceDate, DayCounter dc) {
        this(classI, referenceDate, dc, null);
    }

    protected InterpolatedDiscountCurve(Class<I> classI, Date referenceDate, DayCounter dc, Interpolation.Interpolator interpolator) {
        super(referenceDate, new Calendar(), dc);
        QL.validateExperimentalMode();
        QL.require(classI != null, "Generic type for Interpolation is null");
        this.classI = classI;
        this.interpolator = interpolator == null ? InterpolatedDiscountCurve.constructInterpolator(classI) : interpolator;
    }

    protected InterpolatedDiscountCurve(Class<I> classI, int settlementDays, Calendar calendar, DayCounter dc) {
        this(classI, settlementDays, calendar, dc, null);
    }

    protected InterpolatedDiscountCurve(Class<I> classI, int settlementDays, Calendar calendar, DayCounter dc, Interpolation.Interpolator interpolator) {
        super(settlementDays, new Calendar(), dc);
        QL.validateExperimentalMode();
        QL.require(classI != null, "Generic type for Interpolation is null");
        this.classI = classI;
        this.interpolator = interpolator == null ? InterpolatedDiscountCurve.constructInterpolator(classI) : interpolator;
    }

    private static Interpolation.Interpolator constructInterpolator(Class<?> klass) {
        if (klass == null) {
            throw new LibraryException("null interpolator");
        }
        if (!Interpolation.Interpolator.class.isAssignableFrom(klass)) {
            throw new LibraryException("Unexpected type for type parameter");
        }
        try {
            return (Interpolation.Interpolator)klass.newInstance();
        }
        catch (Exception e) {
            throw new LibraryException("cannot create Interpolator", e);
        }
    }

    @Override
    public Date maxDate() {
        int last = this.dates.length - 1;
        return this.dates[last];
    }

    @Override
    public Date[] dates() {
        return this.dates;
    }

    @Override
    public double[] times() {
        return this.times;
    }

    @Override
    public List<Pair<Date, Double>> nodes() {
        ArrayList<Pair<Date, Double>> nodes = new ArrayList<Pair<Date, Double>>();
        for (int i = 0; i < this.dates.length; ++i) {
            nodes.add(new Pair<Date, Double>(this.dates[i], this.data[i]));
        }
        return nodes;
    }

    @Override
    public double[] data() {
        return this.data;
    }

    @Override
    public Interpolation.Interpolator interpolator() {
        return this.interpolator;
    }

    @Override
    public Interpolation interpolation() {
        return this.interpolation;
    }

    @Override
    public void setInterpolation(Interpolation interpolation) {
        this.interpolation = interpolation;
    }

    @Override
    public void setDates(Date[] dates) {
        this.dates = dates;
    }

    @Override
    public void setTimes(double[] times) {
        this.times = times;
    }

    @Override
    public void setData(double[] data) {
        this.data = data;
    }

    @Override
    public double discount(double t) {
        return this.discountImpl(t);
    }

    @Override
    public double forward(double t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double zeroYield(double t) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected double discountImpl(double t) {
        return this.interpolation.op(t, true);
    }
}

