/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.QL;
import org.jquantlib.currencies.Currency;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.RelativeDateRateHelper;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class FraRateHelper
extends RelativeDateRateHelper {
    private Date fixingDate;
    private final Period periodToStart;
    private final IborIndex iborIndex;
    private final RelinkableHandle<YieldTermStructure> termStructureHandle = new RelinkableHandle<Object>(null);

    public FraRateHelper(Handle<Quote> rate, int monthsToStart, int monthsToEnd, int fixingDays, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter) {
        super(rate);
        this.periodToStart = new Period(monthsToStart, TimeUnit.Months);
        QL.require(monthsToEnd > monthsToStart, "monthsToEnd must be greater than monthsToStart");
        QL.validateExperimentalMode();
        this.iborIndex = new IborIndex("no-fix", new Period(monthsToEnd - monthsToStart, TimeUnit.Months), fixingDays, new Currency(), calendar, convention, endOfMonth, dayCounter, this.termStructureHandle);
        this.initializeDates();
    }

    public FraRateHelper(double rate, int monthsToStart, int monthsToEnd, int fixingDays, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter) {
        super(rate);
        this.periodToStart = new Period(monthsToStart, TimeUnit.Months);
        QL.require(monthsToEnd > monthsToStart, "monthsToEnd must be greater than monthsToStart");
        QL.validateExperimentalMode();
        this.iborIndex = new IborIndex("no-fix", new Period(monthsToEnd - monthsToStart, TimeUnit.Months), fixingDays, new Currency(), calendar, convention, endOfMonth, dayCounter, this.termStructureHandle);
        this.initializeDates();
    }

    public FraRateHelper(Handle<Quote> rate, int monthsToStart, IborIndex i) {
        super(rate);
        this.periodToStart = new Period(monthsToStart, TimeUnit.Months);
        QL.validateExperimentalMode();
        this.iborIndex = new IborIndex("no-fix", i.tenor(), i.fixingDays(), new Currency(), i.fixingCalendar(), i.businessDayConvention(), i.endOfMonth(), i.dayCounter(), this.termStructureHandle);
        this.initializeDates();
    }

    public FraRateHelper(double rate, int monthsToStart, IborIndex i) {
        super(rate);
        this.periodToStart = new Period(monthsToStart, TimeUnit.Months);
        QL.validateExperimentalMode();
        this.iborIndex = new IborIndex("no-fix", i.tenor(), i.fixingDays(), new Currency(), i.fixingCalendar(), i.businessDayConvention(), i.endOfMonth(), i.dayCounter(), this.termStructureHandle);
        this.initializeDates();
    }

    public FraRateHelper(Handle<Quote> rate, Period periodToStart, int lengthInMonths, int fixingDays, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter) {
        super(rate);
        this.periodToStart = periodToStart;
        QL.validateExperimentalMode();
        this.iborIndex = new IborIndex("no-fix", new Period(lengthInMonths, TimeUnit.Months), fixingDays, new Currency(), calendar, convention, endOfMonth, dayCounter, this.termStructureHandle);
        this.initializeDates();
    }

    public FraRateHelper(double rate, Period periodToStart, int lengthInMonths, int fixingDays, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter) {
        super(rate);
        this.periodToStart = periodToStart;
        QL.validateExperimentalMode();
        this.iborIndex = new IborIndex("no-fix", new Period(lengthInMonths, TimeUnit.Months), fixingDays, new Currency(), calendar, convention, endOfMonth, dayCounter, this.termStructureHandle);
        this.initializeDates();
    }

    public FraRateHelper(Handle<Quote> rate, Period periodToStart, IborIndex i) {
        super(rate);
        this.periodToStart = periodToStart;
        QL.validateExperimentalMode();
        this.iborIndex = new IborIndex("no-fix", i.tenor(), i.fixingDays(), new Currency(), i.fixingCalendar(), i.businessDayConvention(), i.endOfMonth(), i.dayCounter(), this.termStructureHandle);
        this.initializeDates();
    }

    public FraRateHelper(double rate, Period periodToStart, IborIndex i) {
        super(rate);
        this.periodToStart = periodToStart;
        QL.validateExperimentalMode();
        this.iborIndex = new IborIndex("no-fix", i.tenor(), i.fixingDays(), new Currency(), i.fixingCalendar(), i.businessDayConvention(), i.endOfMonth(), i.dayCounter(), this.termStructureHandle);
        this.initializeDates();
    }

    @Override
    public double impliedQuote() {
        QL.require(this.termStructure != null, "term structure not set");
        return this.iborIndex.fixing(this.fixingDate, true);
    }

    @Override
    public void setTermStructure(YieldTermStructure t) {
        this.termStructureHandle.linkTo(t, false);
        super.setTermStructure(t);
    }

    @Override
    protected void initializeDates() {
        Date settlement = this.iborIndex.fixingCalendar().advance(this.evaluationDate, new Period(this.iborIndex.fixingDays(), TimeUnit.Days));
        this.earliestDate = this.iborIndex.fixingCalendar().advance(settlement, this.periodToStart, this.iborIndex.businessDayConvention(), this.iborIndex.endOfMonth());
        this.latestDate = this.iborIndex.maturityDate(this.earliestDate);
        this.fixingDate = this.iborIndex.fixingDate(this.earliestDate);
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

