/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.ForwardRateStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;

public class ForwardSpreadedTermStructure
extends ForwardRateStructure {
    private final Handle<YieldTermStructure> originalCurve;
    private final Handle<Quote> spread;

    public ForwardSpreadedTermStructure(Handle<YieldTermStructure> h, Handle<Quote> spread) {
        QL.validateExperimentalMode();
        this.originalCurve = h;
        this.spread = spread;
        this.originalCurve.addObserver(this);
        this.spread.addObserver(this);
    }

    @Override
    public DayCounter dayCounter() {
        return this.originalCurve.currentLink().dayCounter();
    }

    @Override
    public Calendar calendar() {
        return this.originalCurve.currentLink().calendar();
    }

    @Override
    public Date referenceDate() {
        return this.originalCurve.currentLink().referenceDate();
    }

    @Override
    public Date maxDate() {
        return this.originalCurve.currentLink().maxDate();
    }

    @Override
    public double maxTime() {
        return this.originalCurve.currentLink().maxTime();
    }

    @Override
    protected double forwardImpl(double t) {
        return this.originalCurve.currentLink().forwardRate(t, t, Compounding.Continuous, Frequency.NoFrequency, true).rate() + this.spread.currentLink().value();
    }

    @Override
    public double zeroYieldImpl(double t) {
        return this.originalCurve.currentLink().zeroRate(t, Compounding.Continuous, Frequency.NoFrequency, true).rate() + this.spread.currentLink().value();
    }
}

