/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import java.util.Arrays;
import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.math.Constants;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.Traits;
import org.jquantlib.time.Date;

public class Discount
implements Traits {
    private static final double averageRate = 0.05;

    public Discount() {
        QL.validateExperimentalMode();
    }

    @Override
    public double initialValue(YieldTermStructure curve) {
        return 1.0;
    }

    @Override
    public double initialGuess() {
        return 0.9876543209876544;
    }

    @Override
    public double guess(YieldTermStructure c, Date d) {
        return c.discount(d, true);
    }

    @Override
    public double minValueAfter(int i, double[] data) {
        return Constants.QL_EPSILON;
    }

    @Override
    public double maxValueAfter(int i, double[] data) {
        if (new Settings().isNegativeRates()) {
            return 3.0;
        }
        return data[i - 1];
    }

    @Override
    public void updateGuess(double[] data, double value, int i) {
        Arrays.fill(data, value);
    }

    @Override
    public boolean dummyInitialValue() {
        return false;
    }

    @Override
    public Date initialDate(YieldTermStructure curve) {
        return curve.referenceDate();
    }

    @Override
    public int maxIterations() {
        return 50;
    }
}

