/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.termstructures.volatilities.SmileSection;
import org.jquantlib.time.Date;

public class FlatSmileSection
extends SmileSection {
    private final double vol_;
    private final double atmLevel_;

    public FlatSmileSection(Date d, double vol, DayCounter dc, Date referenceDate) {
        this(d, vol, dc, referenceDate, Double.MAX_VALUE);
    }

    public FlatSmileSection(Date d, double vol, DayCounter dc, Date referenceDate, double atmLevel) {
        super(d, dc, referenceDate);
        this.vol_ = vol;
        this.atmLevel_ = atmLevel;
    }

    public FlatSmileSection(double exerciseTime, double vol, DayCounter dc, double atmLevel) {
        super(exerciseTime, dc);
        this.vol_ = vol;
        this.atmLevel_ = atmLevel;
    }

    public FlatSmileSection(double exerciseTime, double vol, DayCounter dc) {
        this(exerciseTime, vol, dc, Double.MAX_VALUE);
    }

    @Override
    public double variance() {
        return this.vol_ * this.vol_ * this.exerciseTime_;
    }

    @Override
    public double volatility() {
        return this.vol_;
    }

    @Override
    public double minStrike() {
        return Double.MIN_VALUE;
    }

    @Override
    public double maxStrike() {
        return Double.MAX_VALUE;
    }

    @Override
    public double atmLevel() {
        return this.atmLevel_;
    }

    @Override
    public double volatilityImpl(double strike) {
        return this.vol_;
    }
}

