/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.interpolations.factories.Linear;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.termstructures.BlackVarianceTermStructure;
import org.jquantlib.time.Date;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class BlackVarianceCurve
extends BlackVarianceTermStructure {
    private final DayCounter dayCounter;
    private final Date maxDate;
    private final Date[] dates;
    private final Array times;
    private final Array variances;
    private Interpolation varianceCurve;
    private final Interpolation.Interpolator factory;

    public BlackVarianceCurve(Date referenceDate, Date[] dates, double[] blackVolCurve, DayCounter dayCounter) {
        this(referenceDate, dates, blackVolCurve, dayCounter, true);
    }

    public BlackVarianceCurve(Date referenceDate, Date[] dates, double[] blackVolCurve, DayCounter dayCounter, boolean forceMonotoneVariance) {
        super(referenceDate);
        QL.require(dates.length == blackVolCurve.length, "mismatch between date vector and black vol vector");
        QL.require(dates[0].gt(referenceDate), "cannot have dates[0] <= referenceDate");
        this.dayCounter = dayCounter;
        this.dates = (Date[])dates.clone();
        this.maxDate = dates[dates.length - 1];
        this.variances = new Array(this.dates.length + 1);
        this.times = new Array(this.dates.length + 1);
        this.variances.set(0, 0.0);
        this.times.set(0, 0.0);
        for (int j = 1; j <= blackVolCurve.length; ++j) {
            this.times.set(j, this.timeFromReference(this.dates[j - 1]));
            QL.require(this.times.get(j) > this.times.get(j - 1), "times must be sorted unique");
            double value = this.times.get(j) * blackVolCurve[j - 1] * blackVolCurve[j - 1];
            this.variances.set(j, value);
            QL.require(this.variances.get(j) >= this.variances.get(j - 1) || !forceMonotoneVariance, "variance must be non-decreasing");
        }
        this.factory = new Linear();
    }

    public void setInterpolation() {
        this.setInterpolation(this.factory);
    }

    public final void setInterpolation(Interpolation.Interpolator factory) {
        this.varianceCurve = factory.interpolate(this.times, this.variances);
        this.varianceCurve.enableExtrapolation();
        this.varianceCurve.update();
        this.notifyObservers();
    }

    @Override
    public final DayCounter dayCounter() {
        return this.dayCounter;
    }

    @Override
    public final Date maxDate() {
        return this.maxDate;
    }

    @Override
    public final double minStrike() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public final double maxStrike() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    protected final double blackVarianceImpl(double t, double maturity) {
        if (t <= this.times.last()) {
            return this.varianceCurve.op(t);
        }
        double lastTime = this.times.last();
        return this.varianceCurve.op(lastTime) * t / lastTime;
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

