/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolatilityTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class BlackConstantVol
extends BlackVolatilityTermStructure {
    private final Handle<? extends Quote> volatility;

    public BlackConstantVol(Date referenceDate, Calendar cal, double volatility, DayCounter dc) {
        super(referenceDate, cal, BusinessDayConvention.Following, dc);
        this.volatility = new Handle<SimpleQuote>(new SimpleQuote(volatility));
    }

    public BlackConstantVol(Date referenceDate, Calendar cal, Handle<? extends Quote> volatility, DayCounter dc) {
        super(referenceDate, cal, BusinessDayConvention.Following, dc);
        this.volatility = volatility;
        this.volatility.addObserver(this);
    }

    public BlackConstantVol(int settlementDays, Calendar cal, double volatility, DayCounter dc) {
        super(settlementDays, cal, BusinessDayConvention.Following, dc);
        this.volatility = new Handle<SimpleQuote>(new SimpleQuote(volatility));
    }

    public BlackConstantVol(int settlementDays, Calendar cal, Handle<? extends Quote> volatility, DayCounter dc) {
        super(settlementDays, cal, BusinessDayConvention.Following, dc);
        this.volatility = volatility;
        this.volatility.addObserver(this);
    }

    @Override
    public final Date maxDate() {
        return Date.maxDate();
    }

    @Override
    public final double minStrike() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public final double maxStrike() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    protected final double blackVolImpl(double maturity, double strike) {
        return this.volatility.currentLink().value();
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

