/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import java.util.Arrays;
import org.jquantlib.QL;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.interpolations.factories.Linear;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.solvers1D.Brent;
import org.jquantlib.termstructures.Bootstrap;
import org.jquantlib.termstructures.BootstrapError;
import org.jquantlib.termstructures.BootstrapHelperSorter;
import org.jquantlib.termstructures.RateHelper;
import org.jquantlib.termstructures.yieldcurves.PiecewiseCurve;
import org.jquantlib.termstructures.yieldcurves.PiecewiseYieldCurve;
import org.jquantlib.termstructures.yieldcurves.Traits;
import org.jquantlib.time.Date;
import org.jquantlib.util.Observer;

public class IterativeBootstrap<Curve extends PiecewiseYieldCurve>
implements Bootstrap<Curve> {
    private boolean validCurve;
    private PiecewiseCurve ts;
    private RateHelper[] instruments;
    private Traits traits;
    private Interpolation.Interpolator interpolator;
    private Interpolation interpolation;
    private final Class<?> typeCurve;

    public IterativeBootstrap(Class<?> typeCurve) {
        QL.validateExperimentalMode();
        if (typeCurve == null) {
            throw new LibraryException("null PiecewiseCurve");
        }
        if (!PiecewiseCurve.class.isAssignableFrom(typeCurve)) {
            throw new LibraryException("Unexpected type for type parameter");
        }
        this.typeCurve = typeCurve;
        this.validCurve = false;
        this.ts = null;
    }

    @Override
    public void setup(Curve ts) {
        QL.ensure(ts != null, "TermStructure cannot be null");
        if (!this.typeCurve.isAssignableFrom(ts.getClass())) {
            throw new LibraryException("Unexpected type for type parameter");
        }
        this.ts = ts;
        this.interpolator = ((PiecewiseYieldCurve)ts).interpolator();
        this.interpolation = ((PiecewiseYieldCurve)ts).interpolation();
        this.traits = ((PiecewiseYieldCurve)ts).traits();
        this.instruments = ((PiecewiseYieldCurve)ts).instruments();
        int n = this.instruments.length;
        QL.require(n + 1 >= ((PiecewiseYieldCurve)ts).interpolator().requiredPoints(), "not enough instruments provided");
        for (int i = 0; i < n; ++i) {
            this.instruments[i].addObserver((Observer)ts);
        }
    }

    @Override
    public void calculate() {
        int i;
        int n = this.instruments.length;
        Date[] dates = this.ts.dates();
        double[] times = this.ts.times();
        double[] data = this.ts.data();
        Arrays.sort(this.instruments, new BootstrapHelperSorter());
        for (i = 1; i < n; ++i) {
            Date m2;
            Date m1 = this.instruments[i - 1].latestDate();
            QL.require(m1 != (m2 = this.instruments[i].latestDate()), "two instruments have the same maturity");
        }
        for (i = 0; i < n; ++i) {
            QL.require(this.instruments[i].quoteIsValid(), " instrument has an invalid quote");
        }
        for (i = 0; i < n; ++i) {
            this.instruments[i].setTermStructure(this.ts);
        }
        dates = new Date[n + 1];
        times = new double[n + 1];
        dates[0] = this.traits.initialDate(this.ts);
        times[0] = this.ts.timeFromReference(dates[0]);
        for (i = 0; i < n; ++i) {
            dates[i + 1] = this.instruments[i].latestDate();
            times[i + 1] = this.ts.timeFromReference(dates[i + 1]);
        }
        this.ts.setDates(dates);
        this.ts.setTimes(times);
        if (this.validCurve) {
            QL.ensure(this.ts.data().length == n + 1, "dimension mismatch");
        } else {
            data = new double[n + 1];
            data[0] = this.traits.initialValue(this.ts);
            for (i = 0; i < n; ++i) {
                data[i + 1] = this.traits.initialGuess();
            }
            this.ts.setData(data);
        }
        Brent solver = new Brent();
        int maxIterations = this.traits.maxIterations();
        int iteration = 0;
        while (true) {
            double[] previousData = (double[])data.clone();
            if (this.validCurve) {
                this.ts.setInterpolation(this.interpolator.interpolate(new Array(times), new Array(data)));
            }
            for (int i2 = 1; i2 < n + 1; ++i2) {
                RateHelper instrument = this.instruments[i2 - 1];
                double guess = 0.0;
                guess = this.validCurve || iteration > 0 ? this.ts.data()[i2] : (i2 == 1 ? this.traits.initialGuess() : this.traits.guess(this.ts, dates[i2]));
                double min = this.traits.minValueAfter(i2, data);
                double max = this.traits.maxValueAfter(i2, data);
                if (guess <= min || guess >= max) {
                    guess = (min + max) / 2.0;
                }
                if (!this.validCurve && iteration == 0) {
                    try {
                        this.ts.setInterpolation(this.interpolator.interpolate(new Array(times, i2 + 1), new Array(data)));
                    }
                    catch (Exception e) {
                        if (this.ts.interpolator().global()) {
                            throw new LibraryException("no chance to fix it in a later iteration");
                        }
                        this.ts.setInterpolation(new Linear().interpolate(new Array(times, i2 + 1), new Array(data)));
                    }
                }
                this.ts.interpolation().update();
                try {
                    double r;
                    BootstrapError error = new BootstrapError(this.traits, this.ts, instrument, i2);
                    data[i2] = r = solver.solve(error, this.ts.accuracy(), guess, min, max);
                    continue;
                }
                catch (Exception e) {
                    this.validCurve = false;
                    QL.error("could not bootstrap");
                }
            }
            if (!this.interpolator.global()) break;
            if (!this.validCurve && iteration == 0) {
                this.ts.setInterpolation(this.interpolator.interpolate(new Array(times), new Array(data)));
            } else {
                double improvement = 0.0;
                for (int i3 = 1; i3 < n + 1; ++i3) {
                    improvement = Math.max(improvement, Math.abs(data[i3] - previousData[i3]));
                }
                if (improvement <= this.ts.accuracy()) break;
                QL.require(iteration + 1 < maxIterations, "convergence not reached after " + Integer.valueOf(iteration + 1).toString() + " iterations; last improvement " + Double.valueOf(improvement).toString() + ", required accuracy " + Double.valueOf(this.ts.accuracy()).toString());
            }
            ++iteration;
        }
        this.validCurve = true;
    }
}

