/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import org.jquantlib.QL;
import org.jquantlib.daycounters.Actual365Fixed;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.termstructures.AbstractTermStructure;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.InterestRate;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.calendars.Target;

public abstract class AbstractYieldTermStructure
extends AbstractTermStructure
implements YieldTermStructure {
    protected AbstractYieldTermStructure() {
        this(new Actual365Fixed());
    }

    protected AbstractYieldTermStructure(DayCounter dc) {
        super(dc);
    }

    protected AbstractYieldTermStructure(Date referenceDate, Calendar cal, DayCounter dc) {
        super(referenceDate, cal, dc);
    }

    protected AbstractYieldTermStructure(Date referenceDate, Calendar cal) {
        super(referenceDate, cal, (DayCounter)new Actual365Fixed());
    }

    protected AbstractYieldTermStructure(Date referenceDate, DayCounter dc) {
        super(referenceDate, (Calendar)new Target(), dc);
    }

    protected AbstractYieldTermStructure(Date referenceDate) {
        super(referenceDate, (Calendar)new Target(), (DayCounter)new Actual365Fixed());
    }

    protected AbstractYieldTermStructure(int settlementDays, Calendar cal, DayCounter dc) {
        super(settlementDays, cal, dc);
    }

    protected AbstractYieldTermStructure(int settlementDays, Calendar cal) {
        super(settlementDays, cal, (DayCounter)new Actual365Fixed());
    }

    protected AbstractYieldTermStructure(int settlementDays, DayCounter dc) {
        super(settlementDays, (Calendar)new Target(), dc);
    }

    protected AbstractYieldTermStructure(int settlementDays) {
        super(settlementDays, (Calendar)new Target(), (DayCounter)new Actual365Fixed());
    }

    protected abstract double discountImpl(double var1);

    @Override
    public final InterestRate zeroRate(Date d, DayCounter resultDayCounter, Compounding comp) {
        return this.zeroRate(d, resultDayCounter, comp, Frequency.Annual);
    }

    @Override
    public final InterestRate zeroRate(Date d, DayCounter resultDayCounter, Compounding comp, Frequency freq) {
        return this.zeroRate(d, resultDayCounter, comp, freq, false);
    }

    @Override
    public final InterestRate zeroRate(Date d, DayCounter dayCounter, Compounding comp, Frequency freq, boolean extrapolate) {
        if (d == this.referenceDate()) {
            double t = 1.0E-4;
            double compound = 1.0 / this.discount(1.0E-4, extrapolate);
            return InterestRate.impliedRate(compound, 1.0E-4, dayCounter, comp, freq);
        }
        double compound = 1.0 / this.discount(d, extrapolate);
        return InterestRate.impliedRate(compound, this.referenceDate(), d, dayCounter, comp, freq);
    }

    @Override
    public InterestRate zeroRate(double time, Compounding comp, Frequency freq, boolean extrapolate) {
        double t = time;
        if (t == 0.0) {
            t = 1.0E-4;
        }
        double compound = 1.0 / this.discount(t, extrapolate);
        return InterestRate.impliedRate(compound, t, this.dayCounter(), comp, freq);
    }

    @Override
    public InterestRate forwardRate(Date d1, Date d2, DayCounter resultDayCounter, Compounding comp) {
        return this.forwardRate(d1, d2, resultDayCounter, comp, Frequency.Annual);
    }

    @Override
    public InterestRate forwardRate(Date d1, Date d2, DayCounter resultDayCounter, Compounding comp, Frequency freq) {
        return this.forwardRate(d1, d2, resultDayCounter, comp, freq, false);
    }

    @Override
    public InterestRate forwardRate(Date d1, Date d2, DayCounter dayCounter, Compounding comp, Frequency freq, boolean extrapolate) {
        if (d1.equals(d2)) {
            double t1 = this.timeFromReference(d1);
            double t2 = t1 + 1.0E-4;
            double delta = t2 - t1;
            double factor1 = this.discount(t1, extrapolate);
            double factor2 = this.discount(t2, extrapolate);
            double compound = factor1 / factor2;
            return InterestRate.impliedRate(compound, delta, dayCounter, comp, freq);
        }
        if (d1.lt(d2)) {
            double discount1 = this.discount(d1, extrapolate);
            double discount2 = this.discount(d2, extrapolate);
            double compound = discount1 / discount2;
            return InterestRate.impliedRate(compound, d1, d2, dayCounter, comp, freq);
        }
        throw new LibraryException("d1 later than d2");
    }

    @Override
    public InterestRate forwardRate(double t1, double t2, Compounding comp) {
        return this.forwardRate(t1, t2, comp, Frequency.Annual);
    }

    @Override
    public InterestRate forwardRate(double t1, double t2, Compounding comp, Frequency freq) {
        return this.forwardRate(t1, t2, comp, freq, false);
    }

    @Override
    public InterestRate forwardRate(double time1, double time2, Compounding comp, Frequency freq, boolean extrapolate) {
        double t2 = time2;
        double t1 = time1;
        if (t2 == t1) {
            t2 = t1 + 1.0E-4;
        }
        QL.require(t1 <= t2, "time1 must be <= time2");
        double discount1 = this.discount(t1, extrapolate);
        double discount2 = this.discount(t2, extrapolate);
        double compound = discount1 / discount2;
        double delta = t2 - t1;
        return InterestRate.impliedRate(compound, delta, this.dayCounter(), comp, freq);
    }

    @Override
    public InterestRate forwardRate(Date d, Period p, DayCounter resultDayCounter, Compounding comp, Frequency freq) {
        return this.forwardRate(d, p, resultDayCounter, comp, freq, false);
    }

    @Override
    public InterestRate forwardRate(Date d, Period p, DayCounter dayCounter, Compounding comp, Frequency freq, boolean extrapolate) {
        return this.forwardRate(d, d.add(p), dayCounter, comp, freq, extrapolate);
    }

    @Override
    public double discount(Date d) {
        return this.discount(d, false);
    }

    @Override
    public double discount(Date d, boolean extrapolate) {
        this.checkRange(d, extrapolate);
        return this.discountImpl(this.timeFromReference(d));
    }

    @Override
    public double discount(double t) {
        return this.discount(t, false);
    }

    @Override
    public double discount(double t, boolean extrapolate) {
        this.checkRange(t, extrapolate);
        return this.discountImpl(t);
    }

    @Override
    public double parRate(int tenor, Date startDate, Frequency freq, boolean extrapolate) {
        Date[] dates = new Date[tenor + 1];
        dates[0] = startDate;
        for (int i = 1; i <= tenor; ++i) {
            dates[i] = startDate.add(new Period(i, TimeUnit.Years));
        }
        return this.parRate(dates, freq, extrapolate);
    }

    @Override
    public double parRate(Date[] dates, Frequency freq, boolean extrapolate) {
        double[] times = new double[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            times[i] = this.timeFromReference(dates[i]);
        }
        return this.parRate(times, freq, extrapolate);
    }

    @Override
    public double parRate(double[] times, Frequency frequency, boolean extrapolate) {
        QL.require(times.length >= 2, "at least two times are required");
        double last = times[times.length - 1];
        this.checkRange(last, extrapolate);
        double sum = 0.0;
        for (int i = 1; i < times.length; ++i) {
            sum += this.discountImpl(times[i]);
        }
        double result = this.discountImpl(times[0]) - this.discountImpl(last);
        int freq = frequency.toInteger();
        return result *= (double)freq / sum;
    }
}

