/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.daycounters.Actual365Fixed;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.interpolations.DefaultExtrapolator;
import org.jquantlib.termstructures.TermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;

public abstract class AbstractTermStructure
implements TermStructure {
    private static final String THIS_METHOD_MUST_BE_OVERRIDDEN = "This method must be overridden";
    private Date referenceDate;
    private final DayCounter dayCounter;
    private boolean updated;
    private final int settlementDays;
    private final boolean moving;
    protected Calendar calendar;
    private final DefaultExtrapolator delegatedExtrapolator = new DefaultExtrapolator();
    private final Observable delegatedObservable = new DefaultObservable(this);

    public AbstractTermStructure() {
        this(new Actual365Fixed());
    }

    public AbstractTermStructure(DayCounter dc) {
        QL.require(dc != null, "day counter must be informed");
        this.calendar = null;
        this.settlementDays = 0;
        this.dayCounter = dc;
        this.moving = false;
        this.updated = true;
        this.referenceDate = null;
    }

    public AbstractTermStructure(Date referenceDate, Calendar calendar) {
        this(referenceDate, calendar, (DayCounter)new Actual365Fixed());
    }

    public AbstractTermStructure(Date referenceDate, Calendar calendar, DayCounter dc) {
        QL.require(referenceDate != null, "reference date must be informed");
        QL.require(calendar != null, "calendar must be informed");
        QL.require(dc != null, "day counter must be informed");
        this.settlementDays = 0;
        this.calendar = calendar;
        this.dayCounter = dc;
        this.moving = false;
        this.updated = true;
        this.referenceDate = referenceDate;
    }

    public AbstractTermStructure(int settlementDays, Calendar calendar) {
        this(settlementDays, calendar, (DayCounter)new Actual365Fixed());
    }

    public AbstractTermStructure(int settlementDays, Calendar calendar, DayCounter dc) {
        this.settlementDays = settlementDays;
        this.calendar = calendar;
        this.dayCounter = dc;
        this.moving = true;
        this.updated = false;
        Date today = new Settings().evaluationDate();
        today.addObserver(this);
        this.referenceDate = calendar.advance(today, settlementDays, TimeUnit.Days);
    }

    protected void checkRange(Date d, boolean extrapolate) {
        QL.require(d.ge(this.referenceDate()), "date before reference date");
        QL.require(extrapolate || this.allowsExtrapolation() || d.le(this.maxDate()), "date is past max curve");
    }

    protected void checkRange(double t, boolean extrapolate) {
        QL.require(t >= 0.0, "negative time given");
        QL.require(extrapolate || this.allowsExtrapolation() || t <= this.maxTime() || Closeness.isCloseEnough(t, this.maxTime()), "time is past max curve");
    }

    @Override
    public Calendar calendar() {
        QL.require(this.calendar != null, THIS_METHOD_MUST_BE_OVERRIDDEN);
        return this.calendar;
    }

    @Override
    public int settlementDays() {
        return this.settlementDays;
    }

    @Override
    public final double timeFromReference(Date date) {
        return this.dayCounter().yearFraction(this.referenceDate(), date);
    }

    @Override
    public DayCounter dayCounter() {
        QL.require(this.dayCounter != null, THIS_METHOD_MUST_BE_OVERRIDDEN);
        return this.dayCounter;
    }

    @Override
    public double maxTime() {
        return this.timeFromReference(this.maxDate());
    }

    @Override
    public Date referenceDate() {
        if (!this.updated) {
            Date today = new Settings().evaluationDate();
            this.referenceDate = this.calendar().advance(today, this.settlementDays, TimeUnit.Days);
            this.updated = true;
        }
        return this.referenceDate;
    }

    @Override
    public final boolean allowsExtrapolation() {
        return this.delegatedExtrapolator.allowsExtrapolation();
    }

    @Override
    public void disableExtrapolation() {
        this.delegatedExtrapolator.disableExtrapolation();
    }

    @Override
    public void enableExtrapolation() {
        this.delegatedExtrapolator.enableExtrapolation();
    }

    @Override
    public void update() {
        if (this.moving) {
            this.updated = false;
        }
        this.notifyObservers();
    }

    @Override
    public void addObserver(Observer observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public void deleteObserver(Observer observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    @Override
    public void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public List<Observer> getObservers() {
        return this.delegatedObservable.getObservers();
    }
}

