/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.processes;

import org.jquantlib.QL;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.processes.StochasticProcess;

public abstract class StochasticProcess1D
extends StochasticProcess {
    private static final String ARRAY_1D_REQUIRED = "1-D array required";
    protected Discretization1D discretization1D;

    protected StochasticProcess1D() {
    }

    protected StochasticProcess1D(Discretization1D discretization) {
        this.discretization1D = discretization;
    }

    public abstract double x0();

    public abstract double drift(double var1, double var3);

    public abstract double diffusion(double var1, double var3);

    public double expectation(double t0, double x0, double dt) {
        return this.apply(x0, this.discretization1D.driftDiscretization(this, t0, x0, dt));
    }

    public double stdDeviation(double t0, double x0, double dt) {
        return this.discretization1D.diffusionDiscretization(this, t0, x0, dt);
    }

    public double variance(double t0, double x0, double dt) {
        return this.discretization1D.varianceDiscretization(this, t0, x0, dt);
    }

    public final double evolve(double t0, double x0, double dt, double dw) {
        return this.apply(this.expectation(t0, x0, dt), this.stdDeviation(t0, x0, dt) * dw);
    }

    public double apply(double x0, double dx) {
        return x0 + dx;
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final Array initialValues() {
        return new Array(1).fill(this.x0());
    }

    @Override
    public final Array drift(double t, Array x) {
        QL.require(x.size() == 1, ARRAY_1D_REQUIRED);
        return new Array(1).fill(this.drift(t, x.first()));
    }

    @Override
    public final Matrix diffusion(double t, Array x) {
        QL.require(x.size() == 1, ARRAY_1D_REQUIRED);
        double v = this.diffusion(t, x.first());
        return new Matrix(1, 1).fill(v);
    }

    @Override
    public final Array expectation(double t0, Array x0, double dt) {
        QL.require(x0.size() == 1, ARRAY_1D_REQUIRED);
        return new Array(1).fill(this.expectation(t0, x0.first(), dt));
    }

    @Override
    public final Matrix stdDeviation(double t0, Array x0, double dt) {
        QL.require(x0.size() == 1, ARRAY_1D_REQUIRED);
        double v = this.stdDeviation(t0, x0.first(), dt);
        return new Matrix(1, 1).fill(v);
    }

    @Override
    public final Matrix covariance(double t0, Array x0, double dt) {
        QL.require(x0.size() == 1, ARRAY_1D_REQUIRED);
        double v = this.discretization1D.varianceDiscretization(this, t0, x0.first(), dt);
        return new Matrix(1, 1).fill(v);
    }

    @Override
    public final Array evolve(double t0, Array x0, double dt, Array dw) {
        QL.require(x0.size() == 1, ARRAY_1D_REQUIRED);
        QL.require(dw.size() == 1, ARRAY_1D_REQUIRED);
        return new Array(1).fill(this.evolve(t0, x0.first(), dt, dw.first()));
    }

    @Override
    public final Array apply(Array x0, Array dx) {
        QL.require(x0.size() == 1, ARRAY_1D_REQUIRED);
        QL.require(dx.size() == 1, ARRAY_1D_REQUIRED);
        return new Array(1).fill(this.apply(x0.first(), dx.first()));
    }

    public static interface Discretization1D {
        public double driftDiscretization(StochasticProcess1D var1, double var2, double var4, double var6);

        public double diffusionDiscretization(StochasticProcess1D var1, double var2, double var4, double var6);

        public double varianceDiscretization(StochasticProcess1D var1, double var2, double var4, double var6);
    }
}

