/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla.finitedifferences;

import java.lang.reflect.Constructor;
import java.util.List;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDVanillaEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.util.Observer;

public abstract class FDEngineAdapter<Base extends FDVanillaEngine, Engine extends OneAssetOption.Engine>
implements OneAssetOption.Engine {
    private final FDVanillaEngine baseInstance;
    private final Class<? extends FDVanillaEngine> classBase;
    private final Class<? extends Engine> classEngine;
    protected OneAssetOption.Engine impl;

    public FDEngineAdapter(Class<? extends FDVanillaEngine> classBase, Class<? extends Engine> classEngine, GeneralizedBlackScholesProcess process, int timeSteps, int gridPoints, boolean timeDependent) {
        this.classBase = classBase;
        this.classEngine = classEngine;
        try {
            Constructor<? extends FDVanillaEngine> baseConstructor = classBase.getConstructor(GeneralizedBlackScholesProcess.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            this.baseInstance = baseConstructor.newInstance(process, timeSteps, gridPoints, timeDependent);
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
        process.addObserver(this);
    }

    @Override
    public void calculate() {
        if (this.impl == null) {
            throw new LibraryException("Pricing engine not set");
        }
        if (!this.classEngine.isAssignableFrom(this.impl.getClass())) {
            throw new LibraryException("Illegal type parameter");
        }
        this.baseInstance.setupArguments(this.impl.getArguments());
        this.baseInstance.calculate(this.impl.getResults());
    }

    @Override
    public void update() {
        if (this.impl == null) {
            throw new LibraryException("Pricing engine not set");
        }
        this.impl.update();
    }

    @Override
    public void addObserver(Observer observer) {
        if (this.impl == null) {
            throw new LibraryException("Pricing engine not set");
        }
        this.impl.addObserver(observer);
    }

    @Override
    public int countObservers() {
        if (this.impl == null) {
            throw new LibraryException("Pricing engine not set");
        }
        return this.impl.countObservers();
    }

    @Override
    public void deleteObserver(Observer observer) {
        if (this.impl == null) {
            throw new LibraryException("Pricing engine not set");
        }
        this.impl.deleteObserver(observer);
    }

    @Override
    public void deleteObservers() {
        if (this.impl == null) {
            throw new LibraryException("Pricing engine not set");
        }
        this.impl.deleteObservers();
    }

    @Override
    public List<Observer> getObservers() {
        if (this.impl == null) {
            throw new LibraryException("Pricing engine not set");
        }
        return this.impl.getObservers();
    }

    @Override
    public void notifyObservers() {
        if (this.impl == null) {
            throw new LibraryException("Pricing engine not set");
        }
        this.impl.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        if (this.impl == null) {
            throw new LibraryException("Pricing engine not set");
        }
        this.impl.notifyObservers(arg);
    }
}

