/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla.finitedifferences;

import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.finitedifferences.NullCondition;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDMultiPeriodEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class FDBermudanEngine
extends OneAssetOption.EngineImpl {
    private double extraTermInBermuda;
    private final FDMultiPeriodEngine fdVanillaEngine;

    public FDBermudanEngine(GeneralizedBlackScholesProcess process) {
        this(process, 100, 100, false);
    }

    public FDBermudanEngine(GeneralizedBlackScholesProcess process, int timeSteps) {
        this(process, timeSteps, 100, false);
    }

    public FDBermudanEngine(GeneralizedBlackScholesProcess process, int timeSteps, int gridPoints) {
        this(process, timeSteps, gridPoints, false);
    }

    public FDBermudanEngine(GeneralizedBlackScholesProcess process, int timeSteps, int gridPoints, boolean timeDependent) {
        this.fdVanillaEngine = new FDBermudianMPEngine(process, timeSteps, gridPoints, timeDependent);
    }

    private void initializeStepCondition() {
        this.fdVanillaEngine.stepCondition = new NullCondition<Array>();
    }

    private void executeIntermediateStep(int step) {
        int size = this.fdVanillaEngine.intrinsicValues.size();
        for (int j = 0; j < size; ++j) {
            this.fdVanillaEngine.prices.values().set(j, Math.max(this.fdVanillaEngine.prices.value(j), this.fdVanillaEngine.intrinsicValues.value(j)));
        }
    }

    @Override
    public void calculate() {
        Option.ArgumentsImpl a = (Option.ArgumentsImpl)this.arguments_;
        this.fdVanillaEngine.setupArguments(a);
        this.fdVanillaEngine.calculate(this.results_);
    }

    private static class FDBermudianMPEngine
    extends FDMultiPeriodEngine {
        public FDBermudianMPEngine(GeneralizedBlackScholesProcess process, int timeSteps, int gridPoints, boolean timeDependent) {
            super(process, timeSteps, gridPoints, timeDependent);
        }

        @Override
        protected void executeIntermediateStep(int step) {
            int size = this.intrinsicValues.size();
            for (int j = 0; j < size; ++j) {
                this.prices.values().set(j, Math.max(this.prices.value(j), this.intrinsicValues.value(j)));
            }
        }
    }
}

