/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.AmericanExercise;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.instruments.VanillaOption;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.pricingengines.BlackCalculator;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class BjerksundStenslandApproximationEngine
extends VanillaOption.EngineImpl {
    private static final String NOT_AN_AMERICAN_OPTION = "not an American Option";
    private static final String NON_AMERICAN_EXERCISE_GIVEN = "non-American exercise given";
    private static final String PAYOFF_AT_EXPIRY_NOT_HANDLED = "payoff at expiry not handled";
    private static final String NON_PLAIN_PAYOFF_GIVEN = "non-plain payoff given";
    private static final String BLACK_SCHOLES_PROCESS_REQUIRED = "Black-Scholes process required";
    private static final String BJERKSUND_NOT_APPLICABLE = "Bjerksund-Stensland approximation not applicable to this set of parameters";
    private final GeneralizedBlackScholesProcess process;
    private final OneAssetOption.ArgumentsImpl a;
    private final OneAssetOption.ResultsImpl r;
    private final Option.GreeksImpl greeks;
    private final Option.MoreGreeksImpl moreGreeks;
    private final CumulativeNormalDistribution cumNormalDist = new CumulativeNormalDistribution();

    public BjerksundStenslandApproximationEngine(GeneralizedBlackScholesProcess process) {
        this.a = (OneAssetOption.ArgumentsImpl)this.arguments_;
        this.r = (OneAssetOption.ResultsImpl)this.results_;
        this.greeks = this.r.greeks();
        this.moreGreeks = this.r.moreGreeks();
        this.process = process;
        this.process.addObserver(this);
    }

    private double phi(double S, double gamma, double H, double I, double rT, double bT, double variance) {
        double lambda = -rT + gamma * bT + 0.5 * gamma * (gamma - 1.0) * variance;
        double d = -(Math.log(S / H) + (bT + (gamma - 0.5) * variance)) / Math.sqrt(variance);
        double kappa = 2.0 * bT / variance + (2.0 * gamma - 1.0);
        return Math.exp(lambda) * Math.pow(S, gamma) * (this.cumNormalDist.op(d) - Math.pow(I / S, kappa) * this.cumNormalDist.op(d - 2.0 * Math.log(I / S) / Math.sqrt(variance)));
    }

    private double americanCallApproximation(double s, double x, double rfD, double dD, double variance) {
        double ht;
        double bT = Math.log(dD / rfD);
        double rT = Math.log(1.0 / rfD);
        double beta = 0.5 - bT / variance + Math.sqrt(Math.pow(bT / variance - 0.5, 2.0) + 2.0 * rT / variance);
        double BInfinity = beta / (beta - 1.0) * x;
        double B0 = Math.max(x, rT / (rT - bT) * x);
        double i = B0 + (BInfinity - B0) * (1.0 - Math.exp(ht = -(bT + 2.0 * Math.sqrt(variance)) * B0 / (BInfinity - B0)));
        QL.require(i >= x, BJERKSUND_NOT_APPLICABLE);
        if (s >= i) {
            return s - x;
        }
        double alpha = (i - x) * Math.pow(i, -beta);
        return alpha * Math.pow(s, beta) - alpha * this.phi(s, beta, i, i, rT, bT, variance) + this.phi(s, 1.0, i, i, rT, bT, variance) - this.phi(s, 1.0, x, i, rT, bT, variance) - x * this.phi(s, 0.0, i, i, rT, bT, variance) + x * this.phi(s, 0.0, x, i, rT, bT, variance);
    }

    @Override
    public void calculate() {
        QL.require(this.a.exercise.type() == Exercise.Type.American, NOT_AN_AMERICAN_OPTION);
        QL.require(this.a.exercise instanceof AmericanExercise, NON_AMERICAN_EXERCISE_GIVEN);
        AmericanExercise ex = (AmericanExercise)this.a.exercise;
        QL.require(!ex.payoffAtExpiry(), PAYOFF_AT_EXPIRY_NOT_HANDLED);
        QL.require(this.a.payoff instanceof PlainVanillaPayoff, NON_PLAIN_PAYOFF_GIVEN);
        PlainVanillaPayoff payoff = (PlainVanillaPayoff)this.a.payoff;
        double variance = this.process.blackVolatility().currentLink().blackVariance(ex.lastDate(), payoff.strike());
        double dividendDiscount = this.process.dividendYield().currentLink().discount(ex.lastDate());
        double riskFreeDiscount = this.process.riskFreeRate().currentLink().discount(ex.lastDate());
        double spot = this.process.stateVariable().currentLink().value();
        QL.require(spot > 0.0, "negative or null underlying given");
        double strike = payoff.strike();
        if (payoff.optionType() == Option.Type.Put) {
            double tmp = spot;
            spot = strike;
            strike = tmp;
            tmp = riskFreeDiscount;
            riskFreeDiscount = dividendDiscount;
            dividendDiscount = tmp;
            payoff = new PlainVanillaPayoff(Option.Type.Call, strike);
        }
        if (dividendDiscount >= 1.0) {
            double forwardPrice = spot * dividendDiscount / riskFreeDiscount;
            BlackCalculator black = new BlackCalculator(payoff, forwardPrice, Math.sqrt(variance), riskFreeDiscount);
            this.r.value = black.value();
            this.greeks.delta = black.delta(spot);
            this.moreGreeks.deltaForward = black.deltaForward();
            this.moreGreeks.elasticity = black.elasticity(spot);
            this.greeks.gamma = black.gamma(spot);
            DayCounter rfdc = this.process.riskFreeRate().currentLink().dayCounter();
            DayCounter divdc = this.process.dividendYield().currentLink().dayCounter();
            DayCounter voldc = this.process.blackVolatility().currentLink().dayCounter();
            double t = rfdc.yearFraction(this.process.riskFreeRate().currentLink().referenceDate(), this.a.exercise.lastDate());
            this.greeks.rho = black.rho(t);
            t = divdc.yearFraction(this.process.dividendYield().currentLink().referenceDate(), this.a.exercise.lastDate());
            this.greeks.dividendRho = black.dividendRho(t);
            t = voldc.yearFraction(this.process.blackVolatility().currentLink().referenceDate(), this.a.exercise.lastDate());
            this.greeks.vega = black.vega(t);
            this.greeks.theta = black.theta(spot, t);
            this.moreGreeks.thetaPerDay = black.thetaPerDay(spot, t);
            this.moreGreeks.strikeSensitivity = black.strikeSensitivity();
            this.moreGreeks.itmCashProbability = black.itmCashProbability();
        } else {
            this.r.value = this.americanCallApproximation(spot, strike, riskFreeDiscount, dividendDiscount, variance);
        }
    }
}

