/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.swap;

import org.jquantlib.QL;
import org.jquantlib.cashflow.CashFlows;
import org.jquantlib.instruments.Swap;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.util.Observer;

public class DiscountingSwapEngine
extends Swap.EngineImpl
implements Observer {
    private final Handle<YieldTermStructure> discountCurve;

    public DiscountingSwapEngine(Handle<YieldTermStructure> discountCurve) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.discountCurve = discountCurve;
        this.discountCurve.addObserver(this);
    }

    @Override
    public void calculate() {
        QL.require(!this.discountCurve.empty(), "no discounting term structure set");
        Swap.ArgumentsImpl a = (Swap.ArgumentsImpl)this.arguments_;
        Swap.ResultsImpl r = (Swap.ResultsImpl)this.results_;
        r.value = 0.0;
        r.errorEstimate = Double.MAX_VALUE;
        r.legNPV = new double[a.legs.size()];
        r.legBPS = new double[a.legs.size()];
        for (int i = 0; i < a.legs.size(); ++i) {
            r.legNPV[i] = a.payer[i] * CashFlows.getInstance().npv(a.legs.get(i), this.discountCurve);
            r.legBPS[i] = a.payer[i] * CashFlows.getInstance().bps(a.legs.get(i), this.discountCurve);
            r.value += r.legNPV[i];
        }
    }
}

