/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines;

import org.jquantlib.QL;
import org.jquantlib.instruments.AssetOrNothingPayoff;
import org.jquantlib.instruments.CashOrNothingPayoff;
import org.jquantlib.instruments.GapPayoff;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.Payoff;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.Constants;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class BlackCalculator {
    private final double strike;
    private final double forward;
    private final double stdDev;
    private final double discount;
    private final double variance;
    private final double dX_dS;
    private final double n_d1;
    private final double cum_d1;
    private final double n_d2;
    private final double cum_d2;
    private double D1;
    private double D2;
    private double alpha;
    private double beta;
    private double dAlpha_dD1;
    private double dBeta_dD2;
    private double x;
    private double dx_dStrike;

    public BlackCalculator(StrikedTypePayoff payoff, double forward, double stdDev) {
        this(payoff, forward, stdDev, 1.0);
    }

    public BlackCalculator(StrikedTypePayoff payoff, double forward, double stdDev, double discount) {
        this.strike = payoff.strike();
        this.forward = forward;
        this.stdDev = stdDev;
        this.discount = discount;
        this.variance = stdDev * stdDev;
        QL.require(forward > 0.0, "positive forward value required");
        QL.require(stdDev >= 0.0, "non-negative standard deviation required");
        QL.require(discount > 0.0, "positive discount required");
        if (stdDev >= Constants.QL_EPSILON) {
            if (this.strike == 0.0) {
                this.n_d1 = 0.0;
                this.n_d2 = 0.0;
                this.cum_d1 = 1.0;
                this.cum_d2 = 1.0;
            } else {
                this.D1 = Math.log(forward / this.strike) / stdDev + 0.5 * stdDev;
                this.D2 = this.D1 - stdDev;
                CumulativeNormalDistribution f = new CumulativeNormalDistribution();
                this.cum_d1 = f.op(this.D1);
                this.cum_d2 = f.op(this.D2);
                this.n_d1 = f.derivative(this.D1);
                this.n_d2 = f.derivative(this.D2);
            }
        } else {
            if (forward > this.strike) {
                this.cum_d1 = 1.0;
                this.cum_d2 = 1.0;
            } else {
                this.cum_d1 = 0.0;
                this.cum_d2 = 0.0;
            }
            this.n_d1 = 0.0;
            this.n_d2 = 0.0;
        }
        this.x = this.strike;
        this.dx_dStrike = 1.0;
        this.dX_dS = 0.0;
        Option.Type optionType = payoff.optionType();
        if (optionType == Option.Type.Call) {
            this.alpha = this.cum_d1;
            this.dAlpha_dD1 = this.n_d1;
            this.beta = -this.cum_d2;
            this.dBeta_dD2 = -this.n_d2;
        } else if (optionType == Option.Type.Put) {
            this.alpha = -1.0 + this.cum_d1;
            this.dAlpha_dD1 = this.n_d1;
            this.beta = 1.0 - this.cum_d2;
            this.dBeta_dD2 = -this.n_d2;
        } else {
            throw new LibraryException("invalid option type");
        }
        Calculator calc = new Calculator(this);
        payoff.accept(calc);
    }

    public double value() {
        double result = this.discount * (this.forward * this.alpha + this.x * this.beta);
        return result;
    }

    public double delta(double spot) {
        QL.require(spot > 0.0, "positive spot value required");
        double DforwardDs = this.forward / spot;
        double temp = this.stdDev * spot;
        double DalphaDs = this.dAlpha_dD1 / temp;
        double DbetaDs = this.dBeta_dD2 / temp;
        double temp2 = DalphaDs * this.forward + this.alpha * DforwardDs + DbetaDs * this.x + this.beta * this.dX_dS;
        return this.discount * temp2;
    }

    public double deltaForward() {
        double temp = this.stdDev * this.forward;
        double DalphaDforward = this.dAlpha_dD1 / temp;
        double DbetaDforward = this.dBeta_dD2 / temp;
        double temp2 = DalphaDforward * this.forward + this.alpha + DbetaDforward * this.x;
        return this.discount * temp2;
    }

    public double elasticity(double spot) {
        double val = this.value();
        double del = this.delta(spot);
        if (val > Constants.QL_EPSILON) {
            return del / val * spot;
        }
        if (Math.abs(del) < Constants.QL_EPSILON) {
            return 0.0;
        }
        if (del > 0.0) {
            return Double.MAX_VALUE;
        }
        return Double.MIN_VALUE;
    }

    public double elasticityForward() {
        double val = this.value();
        double del = this.deltaForward();
        if (val > Constants.QL_EPSILON) {
            return del / val * this.forward;
        }
        if (Math.abs(del) < Constants.QL_EPSILON) {
            return 0.0;
        }
        if (del > 0.0) {
            return Double.MAX_VALUE;
        }
        return Double.MIN_VALUE;
    }

    public double gamma(double spot) {
        QL.require(spot > 0.0, "positive spot value required");
        double DforwardDs = this.forward / spot;
        double temp = this.stdDev * spot;
        double DalphaDs = this.dAlpha_dD1 / temp;
        double DbetaDs = this.dBeta_dD2 / temp;
        double D2alphaDs2 = -DalphaDs / spot * (1.0 + this.D1 / this.stdDev);
        double D2betaDs2 = -DbetaDs / spot * (1.0 + this.D2 / this.stdDev);
        double temp2 = D2alphaDs2 * this.forward + 2.0 * DalphaDs * DforwardDs + D2betaDs2 * this.x + 2.0 * DbetaDs * this.dX_dS;
        return this.discount * temp2;
    }

    public double gammaForward() {
        double temp = this.stdDev * this.forward;
        double DalphaDforward = this.dAlpha_dD1 / temp;
        double DbetaDforward = this.dBeta_dD2 / temp;
        double D2alphaDforward2 = -DalphaDforward / this.forward * (1.0 + this.D1 / this.stdDev);
        double D2betaDforward2 = -DbetaDforward / this.forward * (1.0 + this.D2 / this.stdDev);
        double temp2 = D2alphaDforward2 * this.forward + 2.0 * DalphaDforward + D2betaDforward2 * this.x;
        return this.discount * temp2;
    }

    public double theta(double spot, double maturity) {
        QL.require(maturity > 0.0, "non negative maturity required");
        if (maturity == 0.0) {
            return 0.0;
        }
        return -(Math.log(this.discount) * this.value() + Math.log(this.forward / spot) * spot * this.delta(spot) + 0.5 * this.variance * spot * spot * this.gamma(spot)) / maturity;
    }

    public double thetaPerDay(double spot, double maturity) {
        return this.theta(spot, maturity) / 365.0;
    }

    public double vega(double maturity) {
        QL.require(maturity >= 0.0, "negative maturity not allowed");
        double temp = Math.log(this.strike / this.forward) / this.variance;
        double DalphaDsigma = this.dAlpha_dD1 * (temp + 0.5);
        double DbetaDsigma = this.dBeta_dD2 * (temp - 0.5);
        double temp2 = DalphaDsigma * this.forward + DbetaDsigma * this.x;
        return this.discount * Math.sqrt(maturity) * temp2;
    }

    public double rho(double maturity) {
        QL.require(maturity >= 0.0, "negative maturity not allowed");
        double DalphaDr = this.dAlpha_dD1 / this.stdDev;
        double DbetaDr = this.dBeta_dD2 / this.stdDev;
        double temp = DalphaDr * this.forward + this.alpha * this.forward + DbetaDr * this.x;
        return maturity * (this.discount * temp - this.value());
    }

    public double dividendRho(double maturity) {
        QL.require(maturity >= 0.0, "negative maturity not allowed");
        double DalphaDq = -this.dAlpha_dD1 / this.stdDev;
        double DbetaDq = -this.dBeta_dD2 / this.stdDev;
        double temp = DalphaDq * this.forward - this.alpha * this.forward + DbetaDq * this.x;
        return maturity * this.discount * temp;
    }

    public double itmCashProbability() {
        return this.cum_d2;
    }

    public double itmAssetProbability() {
        return this.cum_d1;
    }

    public double strikeSensitivity() {
        double temp = this.stdDev * this.strike;
        double DalphaDstrike = -this.dAlpha_dD1 / temp;
        double DbetaDstrike = -this.dBeta_dD2 / temp;
        double temp2 = DalphaDstrike * this.forward + DbetaDstrike * this.x + this.beta * this.dx_dStrike;
        return this.discount * temp2;
    }

    public double alpha() {
        return this.alpha;
    }

    public double beta() {
        return this.beta;
    }

    private static class Calculator
    implements PolymorphicVisitor {
        private static final String INVALID_OPTION_TYPE = "invalid option type";
        private static final String INVALID_PAYOFF_TYPE = "invalid payoff type";
        private final BlackCalculator black;
        private final PlainVanillaPayoffVisitor plainVanillaPayoffVisitor = new PlainVanillaPayoffVisitor();
        private final CashOrNothingPayoffVisitor cashOrNothingPayoffVisitor = new CashOrNothingPayoffVisitor();
        private final AssetOrNothingPayoffVisitor assetOrNothingPayoffVisitor = new AssetOrNothingPayoffVisitor();
        private final GapPayoffVisitor gapPayoffVisitor = new GapPayoffVisitor();

        public Calculator(BlackCalculator black) {
            this.black = black;
        }

        public <Payoff> Visitor<Payoff> visitor(Class<? extends Payoff> klass) {
            if (klass == PlainVanillaPayoff.class) {
                return this.plainVanillaPayoffVisitor;
            }
            if (klass == CashOrNothingPayoff.class) {
                return this.cashOrNothingPayoffVisitor;
            }
            if (klass == AssetOrNothingPayoff.class) {
                return this.assetOrNothingPayoffVisitor;
            }
            if (klass == GapPayoff.class) {
                return this.gapPayoffVisitor;
            }
            throw new UnsupportedOperationException(INVALID_PAYOFF_TYPE + klass);
        }

        private final class GapPayoffVisitor
        implements Visitor<Payoff> {
            private GapPayoffVisitor() {
            }

            @Override
            public final void visit(Payoff o) {
                GapPayoff payoff = (GapPayoff)o;
                Calculator.this.black.x = payoff.getSecondStrike();
                Calculator.this.black.dx_dStrike = 0.0;
            }
        }

        private final class AssetOrNothingPayoffVisitor
        implements Visitor<Payoff> {
            private AssetOrNothingPayoffVisitor() {
            }

            @Override
            public void visit(Payoff o) {
                AssetOrNothingPayoff payoff = (AssetOrNothingPayoff)o;
                Calculator.this.black.beta = (Calculator.this.black.dBeta_dD2 = 0.0);
                Option.Type optionType = payoff.optionType();
                if (optionType == Option.Type.Call) {
                    Calculator.this.black.alpha = Calculator.this.black.cum_d1;
                    Calculator.this.black.dAlpha_dD1 = Calculator.this.black.n_d1;
                } else if (optionType == Option.Type.Put) {
                    Calculator.this.black.alpha = 1.0 - Calculator.this.black.cum_d1;
                    Calculator.this.black.dAlpha_dD1 = -Calculator.this.black.n_d1;
                } else {
                    throw new IllegalArgumentException(Calculator.INVALID_OPTION_TYPE);
                }
            }
        }

        private final class CashOrNothingPayoffVisitor
        implements Visitor<Payoff> {
            private CashOrNothingPayoffVisitor() {
            }

            @Override
            public final void visit(Payoff o) {
                CashOrNothingPayoff payoff = (CashOrNothingPayoff)o;
                Calculator.this.black.alpha = (Calculator.this.black.dAlpha_dD1 = 0.0);
                Calculator.this.black.x = payoff.getCashPayoff();
                Calculator.this.black.dx_dStrike = 0.0;
                Option.Type optionType = payoff.optionType();
                if (optionType == Option.Type.Call) {
                    Calculator.this.black.beta = Calculator.this.black.cum_d2;
                    Calculator.this.black.dBeta_dD2 = Calculator.this.black.n_d2;
                } else if (optionType == Option.Type.Put) {
                    Calculator.this.black.beta = 1.0 - Calculator.this.black.cum_d2;
                    Calculator.this.black.dBeta_dD2 = -Calculator.this.black.n_d2;
                } else {
                    throw new IllegalArgumentException(Calculator.INVALID_OPTION_TYPE);
                }
            }
        }

        private static final class PlainVanillaPayoffVisitor
        implements Visitor<Payoff> {
            private PlainVanillaPayoffVisitor() {
            }

            @Override
            public final void visit(Payoff o) {
            }
        }
    }
}

