/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.volatility;

import java.util.Iterator;
import org.jquantlib.time.Date;
import org.jquantlib.time.TimeSeries;

public class SimpleLocalEstimator {
    private final double yearFraction;

    public SimpleLocalEstimator(double y) {
        this.yearFraction = y;
    }

    public TimeSeries<Double> calculate(TimeSeries<Double> quotes) {
        TimeSeries<Double> retval = new TimeSeries<Double>(Double.class);
        Iterator dates = quotes.navigableKeySet().iterator();
        double prev = (Double)quotes.get(dates.next());
        while (dates.hasNext()) {
            Date date = (Date)dates.next();
            double curr = (Double)quotes.get(date);
            double value = Math.abs(Math.log(curr / prev)) / Math.sqrt(this.yearFraction);
            retval.put(date, value);
            prev = curr;
        }
        return retval;
    }
}

