/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.volatility;

import java.util.Iterator;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.IntervalPrice;
import org.jquantlib.model.volatility.GarmanKlassAbstract;
import org.jquantlib.model.volatility.LocalVolatilityEstimator;
import org.jquantlib.time.Date;
import org.jquantlib.time.TimeSeries;

public class GarmanKlassOpenClose<T extends GarmanKlassAbstract>
implements LocalVolatilityEstimator<IntervalPrice> {
    private final double f;
    private final double a;
    private T delegate;
    private final Class<? extends GarmanKlassAbstract> classT;

    public GarmanKlassOpenClose(Class<? extends GarmanKlassAbstract> classT, double y, double marketOpenFraction, double a) {
        this.classT = classT;
        this.delegate = null;
        try {
            this.delegate = classT.getConstructor(Double.TYPE).newInstance(y);
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
        this.f = marketOpenFraction;
        this.a = a;
    }

    @Override
    public TimeSeries<Double> calculate(TimeSeries<IntervalPrice> quotes) {
        TimeSeries<Double> retval = new TimeSeries<Double>(Double.class);
        Iterator it = quotes.navigableKeySet().iterator();
        Date date = (Date)it.next();
        IntervalPrice prev = (IntervalPrice)quotes.get(date);
        while (it.hasNext()) {
            date = (Date)it.next();
            IntervalPrice curr = (IntervalPrice)quotes.get(date);
            double c0 = Math.log(prev.close());
            double o1 = Math.log(curr.open());
            double sigma2 = this.a * (o1 - c0) * (o1 - c0) / this.f + (1.0 - this.a) * ((GarmanKlassAbstract)this.delegate).calculatePoint(curr) / (1.0 - this.f);
            retval.put(date, Math.sqrt(sigma2 / ((GarmanKlassAbstract)this.delegate).getYearFraction()));
            prev = curr;
        }
        return retval;
    }
}

