/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.shortrate.onefactormodels;

import org.jquantlib.instruments.Option;
import org.jquantlib.math.Constants;
import org.jquantlib.math.optimization.NoConstraint;
import org.jquantlib.math.optimization.PositiveConstraint;
import org.jquantlib.model.ConstantParameter;
import org.jquantlib.model.Parameter;
import org.jquantlib.model.shortrate.onefactormodels.OneFactorAffineModel;
import org.jquantlib.model.shortrate.onefactormodels.OneFactorModel;
import org.jquantlib.pricingengines.BlackFormula;
import org.jquantlib.processes.OrnsteinUhlenbeckProcess;

public class Vasicek
extends OneFactorAffineModel {
    protected double r0_;
    protected Parameter a_;
    protected Parameter b_;
    protected Parameter sigma_;
    protected Parameter lambda_;

    public Vasicek(double r0, double a, double b, double sigma, double lambda) {
        super(4);
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.r0_ = r0;
        this.a_ = (Parameter)this.arguments_.get(0);
        this.b_ = (Parameter)this.arguments_.get(1);
        this.sigma_ = (Parameter)this.arguments_.get(2);
        this.lambda_ = (Parameter)this.arguments_.get(3);
        this.a_ = new ConstantParameter(a, new PositiveConstraint());
        this.b_ = new ConstantParameter(b, new NoConstraint());
        this.sigma_ = new ConstantParameter(sigma, new PositiveConstraint());
        this.lambda_ = new ConstantParameter(lambda, new NoConstraint());
    }

    protected double a() {
        return this.a_.get(0.0);
    }

    protected double b() {
        return this.b_.get(0.0);
    }

    protected double lambda() {
        return this.lambda_.get(0.0);
    }

    protected double sigma() {
        return this.sigma_.get(0.0);
    }

    @Override
    public double discountBondOption(Option.Type type, double strike, double maturity, double bondMaturity) {
        double _a = this.a();
        double v = Math.abs(maturity) < Constants.QL_EPSILON ? 0.0 : (_a < Math.sqrt(Constants.QL_EPSILON) ? this.sigma() * this.B(maturity, bondMaturity) * Math.sqrt(maturity) : this.sigma() * this.B(maturity, bondMaturity) * Math.sqrt(0.5 * (1.0 - Math.exp(-2.0 * _a * maturity)) / _a));
        double f = this.discountBond(0.0, bondMaturity, this.r0_);
        double k = this.discountBond(0.0, maturity, this.r0_) * strike;
        return BlackFormula.blackFormula(type, k, f, v);
    }

    @Override
    public OneFactorModel.ShortRateDynamics dynamics() {
        return new Dynamics(this.a(), this.b(), this.sigma(), this.r0_);
    }

    @Override
    protected double A(double t, double T) {
        double _a = this.a();
        if (_a < Math.sqrt(Constants.QL_EPSILON)) {
            return 0.0;
        }
        double sigma2 = this.sigma() * this.sigma();
        double bt = this.B(t, T);
        return Math.exp((this.b() + this.lambda() * this.sigma() / _a - 0.5 * sigma2 / (_a * _a)) * (bt - (T - t)) - 0.25 * sigma2 * bt * bt / _a);
    }

    @Override
    protected double B(double t, double T) {
        double _a = this.a();
        if (_a < Math.sqrt(Constants.QL_EPSILON)) {
            return T - t;
        }
        return (1.0 - Math.exp(-_a * (T - t))) / _a;
    }

    private final class Dynamics
    extends OneFactorModel.ShortRateDynamics {
        private final double a_;
        private final double b_;
        private final double r0_;

        public Dynamics(double a, double b, double sigma, double r0) {
            super(new OrnsteinUhlenbeckProcess(a, sigma, r0 - b, 0.0));
            this.a_ = a;
            this.b_ = b;
            this.r0_ = r0;
        }

        @Override
        public double variable(double t, double r) {
            return r - this.b_;
        }

        @Override
        public double shortRate(double t, double x) {
            return x + this.b_;
        }
    }
}

