/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.shortrate.onefactormodels;

import org.jquantlib.QL;
import org.jquantlib.instruments.Option;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.Constants;
import org.jquantlib.math.distributions.NonCentralChiSquaredDistribution;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.Constraint;
import org.jquantlib.math.optimization.PositiveConstraint;
import org.jquantlib.methods.lattices.Lattice;
import org.jquantlib.methods.lattices.TrinomialTree;
import org.jquantlib.model.ConstantParameter;
import org.jquantlib.model.Parameter;
import org.jquantlib.model.shortrate.onefactormodels.OneFactorAffineModel;
import org.jquantlib.model.shortrate.onefactormodels.OneFactorModel;
import org.jquantlib.processes.StochasticProcess1D;
import org.jquantlib.time.TimeGrid;

public class CoxIngersollRoss
extends OneFactorAffineModel {
    private static final String strike_must_be_positive = "strike must be positive";
    private static final String unsupported_option_type = "unsupported option type";
    private Parameter theta_;
    private Parameter k_;
    private Parameter sigma_;
    private Parameter r0_;

    public CoxIngersollRoss() {
        this(0.05, 0.1, 0.1, 0.1);
    }

    public CoxIngersollRoss(double r0, double theta, double k, double sigma) {
        super(4);
        this.theta_ = (Parameter)this.arguments_.get(0);
        this.k_ = (Parameter)this.arguments_.get(1);
        this.sigma_ = (Parameter)this.arguments_.get(2);
        this.r0_ = (Parameter)this.arguments_.get(3);
        this.theta_ = new ConstantParameter(theta, new PositiveConstraint());
        this.k_ = new ConstantParameter(k, new PositiveConstraint());
        this.sigma_ = new ConstantParameter(sigma, new VolatilityConstraint(k, theta));
        this.r0_ = new ConstantParameter(r0, new PositiveConstraint());
    }

    protected double theta() {
        return this.theta_.get(0.0);
    }

    protected double k() {
        return this.k_.get(0.0);
    }

    protected double sigma() {
        return this.sigma_.get(0.0);
    }

    protected double x0() {
        return this.r0_.get(0.0);
    }

    @Override
    public OneFactorModel.ShortRateDynamics dynamics() {
        return new Dynamics(this.theta(), this.k(), this.sigma(), this.x0());
    }

    @Override
    public double discountBondOption(Option.Type type, double strike, double t, double s) {
        QL.require(strike > 0.0, strike_must_be_positive);
        double discountT = this.discountBond(0.0, t, this.x0());
        double discountS = this.discountBond(0.0, s, this.x0());
        if (t < Constants.QL_EPSILON) {
            switch (type) {
                case Call: {
                    return Math.max(discountS - strike, 0.0);
                }
                case Put: {
                    return Math.max(strike - discountS, 0.0);
                }
            }
            throw new LibraryException(unsupported_option_type);
        }
        double sigma2 = this.sigma() * this.sigma();
        double h = Math.sqrt(this.k() * this.k() + 2.0 * sigma2);
        double b = this.B(t, s);
        double rho = 2.0 * h / (sigma2 * (Math.exp(h * t) - 1.0));
        double psi = (this.k() + h) / sigma2;
        double df = 4.0 * this.k() * this.theta() / sigma2;
        double ncps = 2.0 * rho * rho * this.x0() * Math.exp(h * t) / (rho + psi + b);
        double ncpt = 2.0 * rho * rho * this.x0() * Math.exp(h * t) / (rho + psi);
        NonCentralChiSquaredDistribution chis = new NonCentralChiSquaredDistribution(df, ncps);
        NonCentralChiSquaredDistribution chit = new NonCentralChiSquaredDistribution(df, ncpt);
        double z = Math.log(this.A(t, s) / strike) / b;
        double call = discountS * chis.op(2.0 * z * (rho + psi + b)) - strike * discountT * chit.op(2.0 * z * (rho + psi));
        if (type == Option.Type.Call) {
            return 0.0;
        }
        return 1.0;
    }

    @Override
    public Lattice tree(TimeGrid grid) {
        TrinomialTree trinomial = new TrinomialTree(this.dynamics().process(), grid, true);
        return new OneFactorModel.ShortRateTree(this, trinomial, this.dynamics(), grid);
    }

    @Override
    protected double A(double t, double T) {
        double sigma2 = this.sigma() * this.sigma();
        double h = Math.sqrt(this.k() * this.k() + 2.0 * sigma2);
        double numerator = 2.0 * h * Math.exp(0.5 * (this.k() + h) * (T - t));
        double denominator = 2.0 * h + (this.k() + h) * (Math.exp((T - t) * h) - 1.0);
        double value = Math.log(numerator / denominator) * 2.0 * this.k() * this.theta() / sigma2;
        return Math.exp(value);
    }

    @Override
    protected double B(double t, double T) {
        double h = Math.sqrt(this.k() * this.k() + 2.0 * this.sigma() * this.sigma());
        double temp = Math.exp((T - t) * h) - 1.0;
        double numerator = 2.0 * temp;
        double denominator = 2.0 * h + (this.k() + h) * temp;
        double value = numerator / denominator;
        return value;
    }

    private class HelperProcess
    extends StochasticProcess1D {
        private final double y0_;
        private final double theta_;
        private final double k_;
        private final double sigma_;

        public HelperProcess(double theta, double k, double sigma, double y0) {
            this.y0_ = y0;
            this.theta_ = theta;
            this.k_ = k;
            this.sigma_ = sigma;
        }

        @Override
        public double x0() {
            return this.y0_;
        }

        @Override
        public double drift(double t, double y) {
            return (0.5 * this.theta_ * this.k_ - 0.125 * this.sigma_ * this.sigma_) / y - 0.5 * this.k_ * y;
        }

        @Override
        public double diffusion(double t, double y) {
            return 0.5 * this.sigma_;
        }
    }

    private class VolatilityConstraint
    extends Constraint {
        double k;
        double theta;

        public VolatilityConstraint(double k, double theta) {
            this.k = k;
            this.theta = theta;
        }

        @Override
        public boolean test(Array array) {
            double sigma = array.first();
            if (sigma <= 0.0) {
                return false;
            }
            return !(sigma * sigma >= 2.0 * this.k * this.theta);
        }
    }

    protected class Dynamics
    extends OneFactorModel.ShortRateDynamics {
        public Dynamics(double theta, double k, double sigma, double x0) {
            super(CoxIngersollRoss.this, new HelperProcess(theta, k, sigma, Math.sqrt(x0)));
        }

        @Override
        public double variable(double t, double r) {
            return Math.sqrt(r);
        }

        @Override
        public double shortRate(double t, double y) {
            return y * y;
        }
    }
}

