/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.CompositeConstraint;
import org.jquantlib.math.optimization.Constraint;
import org.jquantlib.math.optimization.CostFunction;
import org.jquantlib.math.optimization.EndCriteria;
import org.jquantlib.math.optimization.OptimizationMethod;
import org.jquantlib.math.optimization.Problem;
import org.jquantlib.model.CalibrationHelper;
import org.jquantlib.model.Parameter;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public abstract class CalibratedModel
implements Observer,
Observable {
    private static final String parameter_array_to_small = "parameter array to small";
    private static final String parameter_array_to_big = "parameter array to big";
    protected List<Parameter> arguments_;
    protected Constraint constraint_;
    protected EndCriteria.Type shortRateEndCriteria_;
    private final DefaultObservable delegatedObservable = new DefaultObservable(this);

    public CalibratedModel(int nArguments) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.arguments_ = new ArrayList<Parameter>(nArguments);
        this.constraint_ = new PrivateConstraint(this.arguments_);
        this.shortRateEndCriteria_ = EndCriteria.Type.None;
    }

    public void calibrate(List<CalibrationHelper> instruments, OptimizationMethod method, EndCriteria endCriteria, Constraint additionalConstraint, double[] weights) {
        QL.require(weights == null || weights.length == instruments.size(), "mismatch between number of instruments and weights");
        Constraint c = additionalConstraint.empty() ? this.constraint_ : new CompositeConstraint(this.constraint_, additionalConstraint);
        double[] w = new double[instruments.size()];
        if (weights == null) {
            Arrays.fill(w, 1.0);
        } else {
            System.arraycopy(weights, 0, w, 0, w.length);
        }
        CalibrationFunction f = new CalibrationFunction(this, instruments, w);
        Problem prob = new Problem(f, c, this.params());
        this.shortRateEndCriteria_ = method.minimize(prob, endCriteria);
        Array result = new Array(prob.currentValue());
        this.setParams(result);
        Array shortRateProblemValues_ = prob.values(result);
        this.notifyObservers();
    }

    public double value(Array params, List<CalibrationHelper> instruments) {
        double[] w = new double[instruments.size()];
        Arrays.fill(w, 1.0);
        CalibrationFunction f = new CalibrationFunction(this, instruments, w);
        return f.value(params);
    }

    public final Constraint constraint() {
        return this.constraint_;
    }

    public EndCriteria.Type endCriteria() {
        return this.shortRateEndCriteria_;
    }

    public Array params() {
        int size = 0;
        for (int i = 0; i < this.arguments_.size(); ++i) {
            size += this.arguments_.get(i).size();
        }
        Array params = new Array(size);
        int k = 0;
        for (int i = 0; i < this.arguments_.size(); ++i) {
            int j = 0;
            while (j < this.arguments_.get(i).size()) {
                double value = this.arguments_.get(i).params().get(j);
                params.set(k, value);
                ++j;
                ++k;
            }
        }
        return params;
    }

    public void setParams(Array params) {
        double[] from = params.$;
        int pos = 0;
        for (int i = 0; i < this.arguments_.size(); ++i) {
            double[] to = this.arguments_.get((int)i).params.$;
            System.arraycopy(from, pos, to, 0, to.length);
            pos += to.length;
        }
        QL.require(pos == params.size(), "parameter array too big");
        this.update();
    }

    protected void generateArguments() {
    }

    @Override
    public void update() {
        this.generateArguments();
        this.notifyObservers();
    }

    @Override
    public void addObserver(Observer observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public void deleteObserver(Observer observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public List<Observer> getObservers() {
        return this.delegatedObservable.getObservers();
    }

    @Override
    public void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    private final class PrivateConstraint
    extends Constraint {
        public PrivateConstraint(List<Parameter> arguments) {
            this.impl = new Impl(arguments);
        }

        private class Impl
        extends Constraint.Impl {
            private final List<Parameter> arguments;

            private Impl(List<Parameter> arguments) {
                this.arguments = arguments;
            }

            @Override
            public boolean test(Array params) {
                int k = 0;
                for (int i = 0; i < CalibratedModel.this.arguments_.size(); ++i) {
                    int size = CalibratedModel.this.arguments_.get(i).size();
                    Array testParams = new Array(size);
                    int j = 0;
                    while (j < size) {
                        testParams.set(j, params.get(k));
                        ++j;
                        ++k;
                    }
                    if (CalibratedModel.this.arguments_.get(i).testParams(testParams)) continue;
                    return false;
                }
                return true;
            }
        }
    }

    private final class CalibrationFunction
    extends CostFunction {
        private final CalibratedModel model;
        private final List<CalibrationHelper> instruments;
        private final double[] weights;

        public CalibrationFunction(CalibratedModel model, List<CalibrationHelper> instruments, double[] weights) {
            this.model = model;
            this.instruments = instruments;
            this.weights = (double[])weights.clone();
        }

        @Override
        public double value(Array params) {
            this.model.setParams(params);
            double value = 0.0;
            for (int i = 0; i < this.instruments.size(); ++i) {
                double diff = this.instruments.get(i).calibrationError();
                value += diff * diff * this.weights[i];
            }
            return Math.sqrt(value);
        }

        @Override
        public Array values(Array params) {
            this.model.setParams(params);
            Array values = new Array(this.instruments.size());
            for (int i = 0; i < this.instruments.size(); ++i) {
                double value = this.instruments.get(i).calibrationError() * Math.sqrt(this.weights[i]);
                values.set(i, value);
            }
            return values;
        }

        @Override
        public double finiteDifferenceEpsilon() {
            return 1.0E-6;
        }
    }
}

