/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.lattices;

import org.jquantlib.lang.annotation.NonNegative;
import org.jquantlib.lang.annotation.Real;
import org.jquantlib.lang.annotation.Time;
import org.jquantlib.lang.annotation.Unused;
import org.jquantlib.methods.lattices.BinomialTree;
import org.jquantlib.processes.StochasticProcess1D;

public class Tian
extends BinomialTree {
    protected double up;
    protected double down;
    protected double pu;
    protected double pd;

    public Tian(StochasticProcess1D process, @Time double end, @NonNegative int steps, @Unused @Real double strike) {
        super(process, end, steps);
        double q = Math.exp(process.variance(0.0, this.x0, this.dt));
        double r = Math.exp(this.driftPerStep) * Math.sqrt(q);
        this.up = 0.5 * r * q * (q + 1.0 + Math.sqrt(q * q + 2.0 * q - 3.0));
        this.down = 0.5 * r * q * (q + 1.0 - Math.sqrt(q * q + 2.0 * q - 3.0));
        this.pu = (r - this.down) / (this.up - this.down);
        this.pd = 1.0 - this.pu;
        if (this.pu < 0.0 || this.pu > 1.0) {
            throw new IllegalStateException("negative probablity");
        }
    }

    @Override
    public double probability(int i, int index, int branch) {
        return branch == 1 ? this.pu : this.pd;
    }

    @Override
    public double underlying(int i, int index) {
        return this.x0 * Math.pow(this.down, i - index) * Math.pow(this.up, index);
    }
}

