/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.lattices;

import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.lattices.Tree;
import org.jquantlib.methods.lattices.TreeLattice1D;
import org.jquantlib.time.TimeGrid;

public class BlackScholesLattice<T extends Tree>
extends TreeLattice1D {
    private final T tree;
    private final double discount;
    private final double pd;
    private final double pu;

    public BlackScholesLattice(T tree, double riskFreeRate, double end, int steps) {
        super(new TimeGrid(end, steps), 2);
        this.tree = tree;
        this.discount = Math.exp(-riskFreeRate * (end / (double)steps));
        this.pd = ((Tree)tree).probability(0, 0, 0);
        this.pu = ((Tree)tree).probability(0, 0, 1);
    }

    @Override
    public int size(int i) {
        return ((Tree)this.tree).size(i);
    }

    @Override
    public double discount(int a, int b) {
        return this.discount;
    }

    @Override
    public double underlying(int i, int index) {
        return ((Tree)this.tree).underlying(i, index);
    }

    @Override
    public int descendant(int i, int index, int branch) {
        return ((Tree)this.tree).descendant(i, index, branch);
    }

    @Override
    public double probability(int i, int index, int branch) {
        return ((Tree)this.tree).probability(i, index, branch);
    }

    @Override
    public void stepback(int i, Array values, Array newValues) {
        for (int j = 0; j < this.size(i); ++j) {
            newValues.set(j, (this.pd * values.get(j) + this.pu * values.get(j + 1)) * this.discount);
        }
    }
}

