/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.finitedifferences;

import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.methods.finitedifferences.Pde;
import org.jquantlib.methods.finitedifferences.PdeSecondOrderParabolic;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class PdeConstantCoeff<T extends Pde>
extends PdeSecondOrderParabolic {
    private final double diffusion;
    private final double drift;
    private final double discount;
    private final Class<? extends Pde> classT;

    public PdeConstantCoeff(Class<? extends Pde> classT, GeneralizedBlackScholesProcess process, double t, double x) {
        this.classT = classT;
        T pde = this.getInstance(classT, process);
        this.diffusion = pde.diffusion(t, x);
        this.drift = pde.drift(t, x);
        this.discount = pde.discount(t, x);
    }

    @Override
    public double diffusion(double t, double x) {
        return this.diffusion;
    }

    @Override
    public double discount(double t, double x) {
        return this.discount;
    }

    @Override
    public double drift(double t, double x) {
        return this.drift;
    }

    protected T getInstance(Class<? extends Pde> classT, GeneralizedBlackScholesProcess process) {
        try {
            return (T)classT.getConstructor(GeneralizedBlackScholesProcess.class).newInstance(process);
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
    }
}

