/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.finitedifferences;

import org.jquantlib.math.LogGrid;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.finitedifferences.PdeBSM;
import org.jquantlib.methods.finitedifferences.PdeConstantCoeff;
import org.jquantlib.methods.finitedifferences.TridiagonalOperator;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class BSMOperator
extends TridiagonalOperator {
    public BSMOperator(int size, double dx, double r, double q, double sigma) {
        super(size);
        double sigma2 = sigma * sigma;
        double nu = r - q - sigma2 / 2.0;
        double pd = -(sigma2 / dx - nu) / (2.0 * dx);
        double pu = -(sigma2 / dx + nu) / (2.0 * dx);
        double pm = sigma2 / (dx * dx) + r;
        this.setMidRows(pd, pm, pu);
    }

    public BSMOperator(Array grid, GeneralizedBlackScholesProcess process, double residualTime) {
        super(grid.size());
        LogGrid logGrid = new LogGrid(grid);
        PdeConstantCoeff cc = new PdeConstantCoeff(PdeBSM.class, process, residualTime, process.stateVariable().currentLink().value());
        cc.generateOperator(residualTime, logGrid, this);
    }
}

