/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.statistics;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.Ops;
import org.jquantlib.math.functions.Bind1st;
import org.jquantlib.math.functions.Bind1stPredicate;
import org.jquantlib.math.functions.Bind2nd;
import org.jquantlib.math.functions.Bind2ndPredicate;
import org.jquantlib.math.functions.Clipped;
import org.jquantlib.math.functions.Constant;
import org.jquantlib.math.functions.Expression;
import org.jquantlib.math.functions.Identity;
import org.jquantlib.math.functions.LessThanPredicate;
import org.jquantlib.math.functions.Minus;
import org.jquantlib.math.functions.Square;
import org.jquantlib.math.functions.TruePredicate;
import org.jquantlib.math.statistics.GaussianStatistics;
import org.jquantlib.util.Pair;

@QualityAssurance(quality=QualityAssurance.Quality.Q4_UNIT, reviewers={"Richard Gomes"}, version=QualityAssurance.Version.V097)
public class GenericRiskStatistics
extends GaussianStatistics {
    private static final String NO_DATA_BELOW_THE_TARGET = "no data below the target";
    private static final String EMPTY_SAMPLE_SET = "empty sample set";
    private static final String UNSUFFICIENT_SAMPLES_UNDER_TARGET = "samples under target <=1, unsufficient";

    public double semiVariance() {
        return this.regret(this.mean());
    }

    public double semiDeviation() {
        return Math.sqrt(this.semiVariance());
    }

    public double downsideVariance() {
        return this.regret(0.0);
    }

    public double downsideDeviation() {
        return Math.sqrt(this.downsideVariance());
    }

    public double regret(double target) {
        ArrayList<Ops.DoubleOp> functions = new ArrayList<Ops.DoubleOp>();
        functions.add(new Square());
        functions.add(new Bind2nd(new Minus(), target));
        Expression comp = new Expression(functions);
        Bind2ndPredicate less = new Bind2ndPredicate(new LessThanPredicate(), target);
        Pair<Double, Integer> result = this.expectationValue(comp, less);
        double x = result.first();
        int n = result.second();
        QL.require(n >= 2, UNSUFFICIENT_SAMPLES_UNDER_TARGET);
        return (double)n / ((double)n - 1.0) * x;
    }

    public double potentialUpside(double centile) {
        QL.require(centile >= 0.9 && centile < 1.0, "percentile out of range [0.9, 1.0)");
        return Math.max(this.percentile(centile), 0.0);
    }

    public double valueAtRisk(double centile) {
        QL.require(centile >= 0.9 && centile < 1.0, "percentile out of range [0.9, 1.0)");
        return -Math.min(this.percentile(1.0 - centile), 0.0);
    }

    public double expectedShortfall(double centile) {
        QL.require(centile >= 0.9 && centile < 1.0, "percentile out of range [0.9, 1.0)");
        QL.ensure(this.samples() != 0, EMPTY_SAMPLE_SET);
        double target = -this.valueAtRisk(centile);
        Bind2ndPredicate less = new Bind2ndPredicate(new LessThanPredicate(), target);
        Pair<Double, Integer> result = this.expectationValue(new Identity(), less);
        double x = result.first();
        Integer N = result.second();
        QL.ensure(N != 0, NO_DATA_BELOW_THE_TARGET);
        return -Math.min(x, 0.0);
    }

    public double shortfall(double target) {
        QL.ensure(this.samples() != 0, EMPTY_SAMPLE_SET);
        Bind2ndPredicate less = new Bind2ndPredicate(new LessThanPredicate(), target);
        return this.expectationValue(new Clipped(less, new Constant(1.0)), new TruePredicate()).first();
    }

    public double averageShortfall(double target) {
        Bind1st minus = new Bind1st(target, new Minus());
        Bind1stPredicate less = new Bind1stPredicate(target, new LessThanPredicate());
        Pair<Double, Integer> result = this.expectationValue(minus, less);
        double x = result.first();
        Integer N = result.second();
        QL.ensure(N != 0, NO_DATA_BELOW_THE_TARGET);
        return x;
    }
}

