/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.statistics;

import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.math.distributions.InverseCumulativeNormal;
import org.jquantlib.math.distributions.NormalDistribution;
import org.jquantlib.math.statistics.GeneralStatistics;

@QualityAssurance(quality=QualityAssurance.Quality.Q4_UNIT, reviewers={"Richard Gomes"}, version=QualityAssurance.Version.V097)
public abstract class GenericGaussianStatistics
extends GeneralStatistics {
    public double gaussianDownsideVariance() {
        return this.gaussianRegret(0.0);
    }

    public double gaussianDownsideDeviation() {
        return Math.sqrt(this.gaussianDownsideVariance());
    }

    public double gaussianRegret(double target) {
        double m = this.mean();
        double std = this.standardDeviation();
        double variance = std * std;
        CumulativeNormalDistribution gIntegral = new CumulativeNormalDistribution(m, std);
        NormalDistribution g = new NormalDistribution(m, std);
        double firstTerm = variance + m * m - 2.0 * target * m + target * target;
        double alfa = gIntegral.op(target);
        double secondTerm = m - target;
        double beta = variance * g.op(target);
        double result = alfa * firstTerm - beta * secondTerm;
        return result / alfa;
    }

    public double gaussianPercentile(double percentile) {
        QL.require(percentile > 0.0, "percentile must be > 0.0");
        QL.require(percentile < 1.0, "percentile must be < 1.0");
        InverseCumulativeNormal gInverse = new InverseCumulativeNormal(this.mean(), this.standardDeviation());
        return gInverse.op(percentile);
    }

    public double gaussianTopPercentile(double percentile) {
        return this.gaussianPercentile(1.0 - percentile);
    }

    public double gaussianPotentialUpside(double percentile) {
        QL.require(percentile < 1.0 && percentile >= 0.9, "percentile is out of range [0.9, 1)");
        double result = this.gaussianPercentile(percentile);
        return Math.max(result, 0.0);
    }

    public double gaussianValueAtRisk(double percentile) {
        QL.require(percentile < 1.0 && percentile >= 0.9, "percentile is out of range [0.9, 1)");
        double result = this.gaussianPercentile(1.0 - percentile);
        return -Math.min(result, 0.0);
    }

    public double gaussianExpectedShortfall(double percentile) {
        QL.require(percentile < 1.0 && percentile >= 0.9, "percentile is out of range [0.9, 1)");
        double m = this.mean();
        double std = this.standardDeviation();
        InverseCumulativeNormal gInverse = new InverseCumulativeNormal(m, std);
        double var = gInverse.op(1.0 - percentile);
        NormalDistribution g = new NormalDistribution(m, std);
        double result = m - std * std * g.op(var) / (1.0 - percentile);
        return -Math.min(result, 0.0);
    }

    public double gaussianShortfall(double target) {
        CumulativeNormalDistribution gIntegral = new CumulativeNormalDistribution(this.mean(), this.standardDeviation());
        return gIntegral.op(target);
    }

    public double gaussianAverageShortfall(double target) {
        double m = this.mean();
        double std = this.standardDeviation();
        CumulativeNormalDistribution gIntegral = new CumulativeNormalDistribution(m, std);
        NormalDistribution g = new NormalDistribution(m, std);
        return target - m + std * std * g.op(target) / gIntegral.op(target);
    }
}

