/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.solvers1D;

import org.jquantlib.math.AbstractSolver1D;
import org.jquantlib.math.Ops;

public class Secant
extends AbstractSolver1D<Ops.DoubleOp> {
    @Override
    protected double solveImpl(Ops.DoubleOp f, double xAccuracy) {
        double fl;
        double xl;
        double froot;
        if (Math.abs(this.fxMin) < Math.abs(this.fxMax)) {
            this.root = this.xMin;
            froot = this.fxMin;
            xl = this.xMax;
            fl = this.fxMax;
        } else {
            this.root = this.xMax;
            froot = this.fxMax;
            xl = this.xMin;
            fl = this.fxMin;
        }
        while (this.evaluationNumber <= this.getMaxEvaluations()) {
            double dx = (xl - this.root) * froot / (froot - fl);
            xl = this.root;
            fl = froot;
            this.root += dx;
            froot = f.op(this.root);
            ++this.evaluationNumber;
            if (!(Math.abs(dx) < xAccuracy) && froot != 0.0) continue;
            return this.root;
        }
        throw new ArithmeticException("maximum number of function evaluations exceeded");
    }
}

