/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.solvers1D;

import org.jquantlib.math.AbstractSolver1D;
import org.jquantlib.math.Ops;

public class Bisection
extends AbstractSolver1D<Ops.DoubleOp> {
    @Override
    protected double solveImpl(Ops.DoubleOp f, double xAccuracy) {
        double dx;
        if (this.fxMin < 0.0) {
            dx = this.xMax - this.xMin;
            this.root = this.xMin;
        } else {
            dx = this.xMin - this.xMax;
            this.root = this.xMax;
        }
        while (this.evaluationNumber <= this.getMaxEvaluations()) {
            double xMid = this.root + (dx /= 2.0);
            double fMid = f.op(xMid);
            ++this.evaluationNumber;
            if (fMid <= 0.0) {
                this.root = xMid;
            }
            if (!(Math.abs(dx) < xAccuracy) && fMid != 0.0) continue;
            return this.root;
        }
        throw new ArithmeticException("maximum number of function evaluations exceeded");
    }
}

