/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.randomnumbers;

import java.lang.reflect.Constructor;
import org.jquantlib.QL;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.randomnumbers.InverseCumulative;
import org.jquantlib.math.randomnumbers.InverseCumulativeRsg;
import org.jquantlib.math.randomnumbers.RandomNumberGenerator;
import org.jquantlib.math.randomnumbers.RandomSequenceGenerator;
import org.jquantlib.math.randomnumbers.UniformRandomSequenceGenerator;

public abstract class GenericPseudoRandom<RNG extends RandomNumberGenerator, IC extends InverseCumulative> {
    private static final boolean allowsErrorEstimate = true;
    private static final GenericPseudoRandom icInstance = null;
    private final Class<? extends UniformRandomSequenceGenerator> classRNG;
    private final Class<? extends InverseCumulative> classIC;

    protected GenericPseudoRandom(Class<? extends UniformRandomSequenceGenerator> classRNG, Class<? extends InverseCumulative> classIC) {
        QL.validateExperimentalMode();
        this.classRNG = classRNG;
        this.classIC = classIC;
    }

    protected InverseCumulativeRsg<RandomSequenceGenerator<RNG>, IC> makeSequenceGenerator(int dimension, long seed) {
        InverseCumulative ic;
        RandomSequenceGenerator rsg;
        Constructor<Object> c;
        RandomNumberGenerator rng;
        try {
            Constructor<? extends UniformRandomSequenceGenerator> c2 = this.classRNG.getConstructor(Long.TYPE);
            rng = (RandomNumberGenerator)((Object)c2.newInstance(seed));
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
        try {
            Class rsgClass = null;
            c = rsgClass.getConstructor(Integer.TYPE, rng.getClass());
            rsg = (RandomSequenceGenerator)c.newInstance(dimension, rng);
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
        try {
            if (icInstance != null) {
                c = this.classIC.getConstructor(rsg.getClass(), this.classIC.getClass());
                ic = (InverseCumulative)c.newInstance(rsg, icInstance);
            } else {
                c = this.classIC.getConstructor(rsg.getClass());
                ic = (InverseCumulative)c.newInstance(rsg);
            }
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
        return (InverseCumulativeRsg)((Object)ic);
    }
}

