/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.optimization;

import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.EndCriteria;
import org.jquantlib.math.optimization.LineSearch;
import org.jquantlib.math.optimization.LineSearchBasedMethod;
import org.jquantlib.math.optimization.Problem;

public class SteepestDescent
extends LineSearchBasedMethod {
    public SteepestDescent(LineSearch lineSearch) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        if (lineSearch == null) {
            lineSearch = new LineSearch();
        }
    }

    @Override
    public EndCriteria.Type minimize(Problem P, EndCriteria endCriteria) {
        EndCriteria.Type ecType = EndCriteria.Type.None;
        P.reset();
        Array x_ = P.currentValue();
        int iterationNumber = 0;
        boolean stationaryStateIterationNumber_ = false;
        this.lineSearch_.setSearchDirection(new Array(x_.size()));
        boolean end = false;
        double t = 1.0;
        Array gold = new Array(this.lineSearch_.searchDirection().size());
        Array gdiff = new Array(this.lineSearch_.searchDirection().size());
        P.setFunctionValue(P.valueAndGradient(gold, x_));
        this.lineSearch_.searchDirection_ = gold.mul(-1.0);
        P.setGradientNormValue(gold.dotProduct(gold));
        double normdiff = Math.sqrt(P.gradientNormValue());
        do {
            t = this.lineSearch_.evaluate(P, ecType, endCriteria, t);
            if (!this.lineSearch_.succeed_) {
                throw new ArithmeticException("line search failed");
            }
            end = endCriteria.get(iterationNumber, 0, true, P.functionValue(), Math.sqrt(P.gradientNormValue()), this.lineSearch_.lastFunctionValue(), Math.sqrt(this.lineSearch_.lastGradientNormNorm2()), ecType);
            x_ = this.lineSearch_.lastX();
            P.setFunctionValue(this.lineSearch_.lastFunctionValue());
            gdiff = gold.sub(this.lineSearch_.lastGradient());
            normdiff = Math.sqrt(gdiff.dotProduct(gdiff));
            gold = this.lineSearch_.lastGradient();
            this.lineSearch_.setSearchDirection(gold.mul(-1.0));
            P.setGradientNormValue(this.lineSearch_.lastGradientNormNorm2());
            ++iterationNumber;
        } while (!end);
        P.setCurrentValue(x_);
        return ecType;
    }
}

