/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.optimization;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.Array;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public abstract class Constraint {
    protected Impl impl;

    public Constraint() {
        this.impl = null;
    }

    public Constraint(Impl impl) {
        this.impl = impl;
    }

    public boolean empty() {
        return this.impl == null;
    }

    public boolean test(Array p) {
        return this.impl.test(p);
    }

    public double update(Array params, Array direction, double beta) {
        double diff = beta;
        Array newParams = params.add(direction.mul(diff));
        boolean valid = this.test(newParams);
        int icount = 0;
        while (!valid) {
            if (icount > 200) {
                throw new LibraryException("can't update parameter vector");
            }
            ++icount;
            newParams = params.add(direction.mul(diff *= 0.5));
            valid = this.test(newParams);
        }
        params.fill(newParams);
        return diff;
    }

    protected abstract class Impl {
        protected Impl() {
        }

        public abstract boolean test(Array var1);
    }
}

