/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities.internal;

import java.util.EnumSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.internal.Address;
import org.jquantlib.math.matrixutilities.internal.DirectAddress;

public class DirectArrayRowAddress
extends DirectAddress
implements Address.ArrayAddress {
    public DirectArrayRowAddress(double[] data, int row, Address chain, int col0, int col1, Set<Address.Flags> flags, boolean contiguous, int rows, int cols) {
        super(data, row, row + 1, chain, col0, col1, flags, contiguous, rows, cols);
    }

    @Override
    public Address.ArrayAddress toFortran() {
        return this.isFortran() ? this : new DirectArrayRowAddress(this.data, this.row0, this.chain, this.col0, this.col1, EnumSet.of(Address.Flags.FORTRAN), this.contiguous, this.rows, this.cols);
    }

    @Override
    public Address.ArrayAddress toJava() {
        return this.isFortran() ? new DirectArrayRowAddress(this.data, this.row0 + 1, this.chain, this.col0 + 1, this.col1 + 1, EnumSet.noneOf(Address.Flags.class), this.contiguous, this.rows, this.cols) : this;
    }

    @Override
    public Address.ArrayAddress.ArrayOffset offset() {
        return new DirectArrayRowAddressOffset(this.offset, this.offset);
    }

    @Override
    public Address.ArrayAddress.ArrayOffset offset(int index) {
        return new DirectArrayRowAddressOffset(this.offset, index);
    }

    @Override
    public int op(int index) {
        return (this.row0 + this.offset) * this.cols + (this.col0 + index);
    }

    @Override
    public DirectArrayRowAddress clone() {
        try {
            return (DirectArrayRowAddress)super.clone();
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
    }

    private class DirectArrayRowAddressOffset
    extends DirectAddress.DirectAddressOffset
    implements Address.ArrayAddress.ArrayOffset {
        public DirectArrayRowAddressOffset(int row, int col) {
            this.row = DirectArrayRowAddress.this.row0 + row;
            this.col = DirectArrayRowAddress.this.col0 + col;
        }

        @Override
        public int op() {
            return this.row * DirectArrayRowAddress.this.cols + this.col;
        }

        @Override
        public void setIndex(int index) {
            this.col = DirectArrayRowAddress.this.col0 + index;
        }

        @Override
        public void add(Double e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextIndex() {
            int n;
            if (this.col == DirectArrayRowAddress.this.cols) {
                n = DirectArrayRowAddress.this.cols;
            } else {
                int n2 = this.col;
                n = n2;
                this.col = n2 + 1;
            }
            return n;
        }

        @Override
        public int previousIndex() {
            int n;
            if (this.col == -1) {
                n = -1;
            } else {
                int n2 = this.col;
                n = n2;
                this.col = n2 - 1;
            }
            return n;
        }

        @Override
        public boolean hasNext() {
            return this.col < DirectArrayRowAddress.this.col1;
        }

        @Override
        public boolean hasPrevious() {
            return this.col > -1;
        }

        @Override
        public Double next() {
            int idx = this.op();
            this.nextIndex();
            if (idx == DirectArrayRowAddress.this.col1) {
                throw new NoSuchElementException();
            }
            return DirectArrayRowAddress.this.data[idx];
        }

        @Override
        public Double previous() {
            int idx = this.previousIndex();
            if (idx == -1) {
                throw new NoSuchElementException();
            }
            return DirectArrayRowAddress.this.data[this.op()];
        }

        @Override
        public void set(Double e) {
            int idx = this.op();
            if (idx == -1 || idx == DirectArrayRowAddress.this.cols) {
                throw new IllegalStateException();
            }
            DirectArrayRowAddress.this.data[idx] = e;
        }
    }
}

