/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities;

import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.math.matrixutilities.internal.Address;

@QualityAssurance(quality=QualityAssurance.Quality.Q0_UNFINISHED, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class SymmetricSchurDecomposition {
    private static final double epsPrec = 1.0E-15;
    private static final int maxIterations = 100;
    private final int size;
    private final Matrix A;
    private final Array diag;

    public SymmetricSchurDecomposition(Matrix m) {
        int offset;
        QL.require(m.rows() == m.cols(), "matrix must be square");
        this.size = m.rows();
        this.A = new Matrix(m.rows(), m.cols(), m.flags());
        this.diag = new Array(this.size, m.flags());
        double[] tmpDiag = new double[this.size];
        double[] tmpSum = new double[this.size];
        Matrix s = m.clone();
        for (int q = offset = s.offset(); q < this.size + offset; ++q) {
            this.diag.$[((Address.ArrayAddress)this.diag.addr).op((int)q)] = s.$[((Address.MatrixAddress)s.addr).op(q, q)];
            this.A.$[((Address.MatrixAddress)this.A.addr).op((int)q, (int)q)] = 1.0;
        }
        for (int j = 0; j < this.size; ++j) {
            tmpDiag[j] = this.diag.$[((Address.ArrayAddress)this.diag.addr).op(j + offset)];
        }
        boolean keeplooping = true;
        int ite = 1;
        do {
            int k;
            double sum = 0.0;
            for (int a = offset; a < this.size - 1 + offset; ++a) {
                for (int b = a + 1; b < this.size + offset; ++b) {
                    sum += Math.abs(s.$[((Address.MatrixAddress)s.addr).op(a, b)]);
                }
            }
            if (sum == 0.0) {
                keeplooping = false;
                continue;
            }
            double threshold = ite < 5 ? 0.2 * sum / (double)(this.size * this.size) : 0.0;
            for (int j = offset; j < this.size - 1 + offset; ++j) {
                for (k = j + 1; k < this.size + offset; ++k) {
                    double tang;
                    double smll = Math.abs(s.$[((Address.MatrixAddress)s.addr).op(j, k)]);
                    if (ite > 5 && smll < 1.0E-15 * Math.abs(this.diag.$[((Address.ArrayAddress)this.diag.addr).op(j)]) && smll < 1.0E-15 * Math.abs(this.diag.$[((Address.ArrayAddress)this.diag.addr).op(k)])) {
                        s.$[((Address.MatrixAddress)s.addr).op((int)j, (int)k)] = 0.0;
                        continue;
                    }
                    if (!(Math.abs(s.$[((Address.MatrixAddress)s.addr).op(j, k)]) > threshold)) continue;
                    double heig = this.diag.$[((Address.ArrayAddress)this.diag.addr).op(k)] - this.diag.$[((Address.ArrayAddress)this.diag.addr).op(j)];
                    if (smll < 1.0E-15 * Math.abs(heig)) {
                        tang = s.$[((Address.MatrixAddress)s.addr).op(j, k)] / heig;
                    } else {
                        double beta = 0.5 * heig / s.$[((Address.MatrixAddress)s.addr).op(j, k)];
                        tang = 1.0 / (Math.abs(beta) + Math.sqrt(1.0 + beta * beta));
                        if (beta < 0.0) {
                            tang = -tang;
                        }
                    }
                    double cosin = 1.0 / Math.sqrt(1.0 + tang * tang);
                    double sine = tang * cosin;
                    double rho = sine / (1.0 + cosin);
                    heig = tang * s.$[((Address.MatrixAddress)s.addr).op(j, k)];
                    int n = j - offset;
                    tmpSum[n] = tmpSum[n] - heig;
                    int n2 = k - offset;
                    tmpSum[n2] = tmpSum[n2] + heig;
                    int n3 = ((Address.ArrayAddress)this.diag.addr).op(j);
                    this.diag.$[n3] = this.diag.$[n3] - heig;
                    int n4 = ((Address.ArrayAddress)this.diag.addr).op(k);
                    this.diag.$[n4] = this.diag.$[n4] + heig;
                    s.$[((Address.MatrixAddress)s.addr).op((int)j, (int)k)] = 0.0;
                    int l = offset;
                    while (l + 1 <= j) {
                        this.jacobiRotate(s, rho, sine, l, j, l, k);
                        ++l;
                    }
                    for (l = j + 1; l <= k - 1; ++l) {
                        this.jacobiRotate(s, rho, sine, j, l, l, k);
                    }
                    for (l = k + 1; l < this.size + offset; ++l) {
                        this.jacobiRotate(s, rho, sine, j, l, k, l);
                    }
                    for (l = offset; l < this.size + offset; ++l) {
                        this.jacobiRotate(this.A, rho, sine, l, j, l, k);
                    }
                }
            }
            for (k = 0; k < this.size; ++k) {
                int n = k;
                tmpDiag[n] = tmpDiag[n] + tmpSum[k];
                this.diag.$[((Address.ArrayAddress)this.diag.addr).op((int)(k + offset))] = tmpDiag[k];
                tmpSum[k] = 0.0;
            }
        } while (++ite <= 100 && keeplooping);
        QL.ensure(ite <= 100, "Too many iterations reached");
    }

    public Matrix eigenvectors() {
        return this.A.clone();
    }

    public Array eigenvalues() {
        return this.diag.clone();
    }

    private void jacobiRotate(Matrix m, double rot, double dil, int j1, int k1, int j2, int k2) {
        double x1 = m.$[((Address.MatrixAddress)m.addr).op(j1, k1)];
        double x2 = m.$[((Address.MatrixAddress)m.addr).op(j2, k2)];
        m.$[((Address.MatrixAddress)m.addr).op((int)j1, (int)k1)] = x1 - dil * (x2 + x1 * rot);
        m.$[((Address.MatrixAddress)m.addr).op((int)j2, (int)k2)] = x2 + dil * (x1 - x2 * rot);
    }
}

