/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities;

import java.util.Set;
import org.jquantlib.QL;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.internal.Address;

public abstract class Cells<T extends Address>
implements Cloneable {
    private static final String FORTRAN_ADDRESSING_EXPECTED = "variable \"%s\" should be FORTRAN-style addressing";
    protected static final String INVALID_ARGUMENTS = "invalid arguments";
    protected static final String WRONG_BUFFER_LENGTH = "wrong buffer length";
    protected static final String MATRIX_IS_INCOMPATIBLE = "matrix is incompatible";
    protected static final String ARRAY_IS_INCOMPATIBLE = "array is incompatible";
    protected static final String ITERATOR_IS_INCOMPATIBLE = "iterator is incompatible";
    protected static final String NOT_ENOUGH_STORAGE = "not enough storage area for operation";
    protected static final String MATRIX_MUST_BE_SQUARE = "matrix must be square";
    protected static final String MATRIX_MUST_BE_SYMMETRIC = "matrix must be symmetric";
    protected static final String MATRIX_IS_SINGULAR = "matrix is singular";
    protected static final String NON_CONTIGUOUS_DATA = "Operation not supported on non-contiguous data";
    protected final int rows;
    protected final int cols;
    protected final int size;
    protected T addr;
    @Deprecated
    public double[] $;

    protected Cells(int rows, int cols, T addr) {
        this.rows = rows;
        this.cols = cols;
        this.addr = addr;
        this.size = rows * cols;
        this.$ = new double[this.size];
    }

    protected Cells(int rows, int cols, double[] data, T addr) {
        this.rows = rows;
        this.cols = cols;
        this.$ = data;
        this.addr = addr;
        this.size = rows * cols;
        if (data.length != addr.rows() * addr.cols()) {
            throw new IllegalArgumentException("declared dimension do not match underlying storage size");
        }
    }

    public final int rows() {
        return this.rows;
    }

    public final int columns() {
        return this.cols;
    }

    public final int cols() {
        return this.cols;
    }

    public final int size() {
        return this.size;
    }

    public final boolean empty() {
        return this.size <= 0;
    }

    public final Set<Address.Flags> flags() {
        return this.addr.flags();
    }

    public void requireFlags(Set<Address.Flags> required, String variable) {
        if (required.contains((Object)Address.Flags.FORTRAN) != this.addr.isFortran()) {
            String name = variable == null ? "variable" : this.getClass().getSimpleName() + " " + variable;
            String message = String.format(FORTRAN_ADDRESSING_EXPECTED, name);
            QL.error(String.format(FORTRAN_ADDRESSING_EXPECTED, name));
        }
    }

    public Cells clone() {
        try {
            return (Cells)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new LibraryException(e);
        }
    }
}

