/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import org.jquantlib.QL;
import org.jquantlib.lang.annotation.Time;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.interpolations.AbstractInterpolation;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.CostFunction;
import org.jquantlib.math.optimization.EndCriteria;
import org.jquantlib.math.optimization.NoConstraint;
import org.jquantlib.math.optimization.OptimizationMethod;
import org.jquantlib.math.optimization.ParametersTransformation;
import org.jquantlib.math.optimization.Problem;
import org.jquantlib.math.optimization.ProjectedCostFunction;
import org.jquantlib.math.optimization.Simplex;
import org.jquantlib.pricingengines.BlackFormula;
import org.jquantlib.termstructures.volatilities.Sabr;

public class SABRInterpolation
extends AbstractInterpolation {
    private final SABRCoeffHolder coeffs_;

    public SABRInterpolation(Array vx, Array vy, @Time double t, double forward, double alpha, double beta, double nu, double rho, boolean alphaIsFixed, boolean betaIsFixed, boolean nuIsFixed, boolean rhoIsFixed, boolean vegaWeighted, EndCriteria endCriteria, OptimizationMethod optMethod) {
        this.impl = new SABRInterpolationImpl(vx, vy, t, forward, alpha, beta, nu, rho, alphaIsFixed, betaIsFixed, nuIsFixed, rhoIsFixed, vegaWeighted, endCriteria, optMethod);
        this.coeffs_ = ((SABRInterpolationImpl)this.impl).itsCoeffs;
    }

    public double expiry() {
        return this.coeffs_.t_;
    }

    public double forward() {
        return this.coeffs_.forward_;
    }

    public double alpha() {
        return this.coeffs_.alpha_;
    }

    public double beta() {
        return this.coeffs_.beta_;
    }

    public double nu() {
        return this.coeffs_.nu_;
    }

    public double rho() {
        return this.coeffs_.rho_;
    }

    public double rmsError() {
        return this.coeffs_.error_;
    }

    public double maxError() {
        return this.coeffs_.maxError_;
    }

    public Array interpolationWeights() {
        return this.coeffs_.weights_;
    }

    public EndCriteria.Type endCriteria() {
        return this.coeffs_.SABREndCriteria_;
    }

    private class SABRInterpolationImpl
    extends AbstractInterpolation.Impl {
        EndCriteria endCriteria_;
        OptimizationMethod optMethod_;
        double forward_;
        boolean vegaWeighted_;
        ParametersTransformation transformation_;
        NoConstraint constraint_;
        public SABRCoeffHolder itsCoeffs;

        public SABRInterpolationImpl(Array vx, @Time Array vy, double t, double forward, double alpha, double beta, double nu, double rho, boolean alphaIsFixed, boolean betaIsFixed, boolean nuIsFixed, boolean rhoIsFixed, boolean vegaWeighted, EndCriteria endCriteria, OptimizationMethod optMethod) {
            super(vx, vy);
            this.itsCoeffs = new SABRCoeffHolder(t, forward, alpha, beta, nu, rho, alphaIsFixed, betaIsFixed, nuIsFixed, rhoIsFixed);
            this.endCriteria_ = endCriteria;
            this.optMethod_ = optMethod;
            this.forward_ = forward;
            this.vegaWeighted_ = vegaWeighted;
            if (this.optMethod_ != null) {
                this.optMethod_ = new Simplex(0.01);
            }
            if (this.endCriteria_ != null) {
                this.endCriteria_ = new EndCriteria(60000, 100, 1.0E-8, 1.0E-8, 1.0E-8);
            }
            this.itsCoeffs.weights_ = new Array(vx.size());
            for (int i = 0; i < this.itsCoeffs.weights_.size(); ++i) {
                this.itsCoeffs.weights_.set(i, 1.0 / (double)vx.size());
            }
        }

        @Override
        public void update() {
            QL.require(this.forward_ > 0.0, "at the money forward rate must be positive: " + this.forward_ + " not allowed");
            if (this.vegaWeighted_) {
                int i;
                double weightsSum = 0.0;
                for (i = 0; i < this.vx.size(); ++i) {
                    double x = this.vx.get(i);
                    double y = this.vy.get(i);
                    double stdDev = Math.sqrt(y * y * this.itsCoeffs.t_);
                    this.itsCoeffs.weights_.set(i, BlackFormula.blackFormulaStdDevDerivative(x, this.forward_, stdDev));
                    weightsSum += this.itsCoeffs.weights_.get(i);
                }
                for (i = 0; i < this.itsCoeffs.weights_.size(); ++i) {
                    this.itsCoeffs.weights_.set(i, this.itsCoeffs.weights_.get(i) / weightsSum);
                }
            }
            if (this.itsCoeffs.alphaIsFixed_ && this.itsCoeffs.betaIsFixed_ && this.itsCoeffs.nuIsFixed_ && this.itsCoeffs.rhoIsFixed_) {
                this.itsCoeffs.error_ = this.interpolationError();
                this.itsCoeffs.maxError_ = this.interpolationMaxError();
                this.itsCoeffs.SABREndCriteria_ = EndCriteria.Type.None;
                return;
            }
            SABRError costFunction = new SABRError(this);
            this.transformation_ = new SabrParametersTransformation();
            Array guess = new Array(4);
            guess.set(0, this.itsCoeffs.alpha_);
            guess.set(1, this.itsCoeffs.beta_);
            guess.set(2, this.itsCoeffs.nu_);
            guess.set(3, this.itsCoeffs.rho_);
            boolean[] parameterAreFixed = new boolean[]{this.itsCoeffs.alphaIsFixed_, this.itsCoeffs.betaIsFixed_, this.itsCoeffs.nuIsFixed_, this.itsCoeffs.rhoIsFixed_};
            Array inversedTransformatedGuess = new Array(this.transformation_.inverse(guess));
            ProjectedCostFunction constrainedSABRError = new ProjectedCostFunction(costFunction, inversedTransformatedGuess, parameterAreFixed);
            Array projectedGuess = new Array(constrainedSABRError.project(inversedTransformatedGuess));
            NoConstraint constraint = new NoConstraint();
            Problem problem = new Problem(constrainedSABRError, constraint, projectedGuess);
            this.itsCoeffs.SABREndCriteria_ = this.optMethod_.minimize(problem, this.endCriteria_);
            Array projectedResult = new Array(problem.currentValue());
            Array transfResult = new Array(constrainedSABRError.include(projectedResult));
            Array result = this.transformation_.direct(transfResult);
            this.itsCoeffs.alpha_ = result.get(0);
            this.itsCoeffs.beta_ = result.get(1);
            this.itsCoeffs.nu_ = result.get(2);
            this.itsCoeffs.rho_ = result.get(3);
            this.itsCoeffs.error_ = this.interpolationError();
            this.itsCoeffs.maxError_ = this.interpolationMaxError();
        }

        @Override
        public double op(double x) {
            QL.require(x > 0.0, "strike must be positive: " + x + " not allowed");
            return new Sabr().sabrVolatility(x, this.forward_, this.itsCoeffs.t_, this.itsCoeffs.alpha_, this.itsCoeffs.beta_, this.itsCoeffs.nu_, this.itsCoeffs.rho_);
        }

        @Override
        public double primitive(double x) {
            throw new LibraryException("SABR primitive not implemented");
        }

        @Override
        public double derivative(double x) {
            throw new LibraryException("SABR derivative not implemented");
        }

        @Override
        public double secondDerivative(double x) {
            throw new LibraryException("SABR secondDerivative not implemented");
        }

        public double interpolationSquaredError() {
            double totalError = 0.0;
            int ix = this.vx.begin();
            int iy = this.vy.begin();
            int iw = this.itsCoeffs.weights_.begin();
            while (ix < this.vx.end()) {
                double x = this.vx.get(ix);
                double y = this.vy.get(iy);
                double w = this.itsCoeffs.weights_.get(iw);
                double error = this.op(x) - y;
                totalError += error * error * w;
                ++ix;
                ++iy;
                ++iw;
            }
            return totalError;
        }

        public Array interpolationErrors(Array not_used) {
            Array results = new Array(this.vx.size());
            int ix = this.vx.begin();
            int iy = this.vy.begin();
            int iw = this.itsCoeffs.weights_.begin();
            int ir = results.begin();
            while (ix < this.vx.end()) {
                double x = this.vx.get(ix);
                double y = this.vy.get(iy);
                double w = this.itsCoeffs.weights_.get(iw);
                results.set(ir, (this.op(x) - y) * Math.sqrt(w));
                ++ix;
                ++iy;
                ++iw;
                ++ir;
            }
            return results;
        }

        public double interpolationError() {
            int n = this.vx.size();
            double squaredError = this.interpolationSquaredError();
            return Math.sqrt((double)n * squaredError / (double)(n - 1));
        }

        public double interpolationMaxError() {
            double maxError = Double.MIN_VALUE;
            for (int i = 0; i < this.vx.size(); ++i) {
                double x = this.vx.get(i);
                double y = this.vy.get(i);
                double error = Math.abs(this.op(x) - y);
                maxError = Math.max(maxError, error);
            }
            return maxError;
        }

        private class SABRError
        extends CostFunction {
            private final SABRInterpolationImpl sabr_;

            public SABRError(SABRInterpolationImpl sabr) {
                this.sabr_ = sabr;
            }

            @Override
            public double value(Array x) {
                Array y = this.sabr_.transformation_.direct(x);
                this.sabr_.itsCoeffs.alpha_ = y.get(0);
                this.sabr_.itsCoeffs.beta_ = y.get(1);
                this.sabr_.itsCoeffs.nu_ = y.get(2);
                this.sabr_.itsCoeffs.rho_ = y.get(3);
                return this.sabr_.interpolationSquaredError();
            }

            @Override
            public Array values(Array x) {
                Array y = this.sabr_.transformation_.direct(x);
                this.sabr_.itsCoeffs.alpha_ = y.get(0);
                this.sabr_.itsCoeffs.beta_ = y.get(1);
                this.sabr_.itsCoeffs.nu_ = y.get(2);
                this.sabr_.itsCoeffs.rho_ = y.get(3);
                return this.sabr_.interpolationErrors(x);
            }
        }

        private class SabrParametersTransformation
        implements ParametersTransformation {
            Array y_ = new Array(4);
            final double eps1_;
            final double eps2_;

            public SabrParametersTransformation() {
                this.eps1_ = 1.0E-7;
                this.eps2_ = 0.9999;
            }

            @Override
            public Array direct(Array x) {
                this.y_.set(0, x.get(0) * x.get(0) + this.eps1_);
                this.y_.set(1, Math.exp(-(x.get(1) * x.get(1))));
                this.y_.set(2, x.get(2) * x.get(2) + this.eps1_);
                this.y_.set(3, this.eps2_ * Math.sin(x.get(3)));
                return this.y_;
            }

            @Override
            public Array inverse(Array x) {
                this.y_.set(0, Math.sqrt(x.get(0) - this.eps1_));
                this.y_.set(1, Math.sqrt(-Math.log(x.get(1))));
                this.y_.set(2, Math.sqrt(x.get(2) - this.eps1_));
                this.y_.set(3, Math.asin(x.get(3) / this.eps2_));
                return this.y_;
            }
        }
    }

    private class SABRCoeffHolder {
        public double t_;
        public double forward_;
        public double alpha_;
        public double beta_;
        public double nu_;
        public double rho_;
        public boolean alphaIsFixed_;
        public boolean betaIsFixed_;
        public boolean nuIsFixed_;
        public boolean rhoIsFixed_;
        public Array weights_;
        public double error_;
        public double maxError_;
        public EndCriteria.Type SABREndCriteria_;

        public SABRCoeffHolder(double t, double forward, double alpha, double beta, double nu, double rho, boolean alphaIsFixed, boolean betaIsFixed, boolean nuIsFixed, boolean rhoIsFixed) {
            this.t_ = t;
            this.forward_ = forward;
            this.alpha_ = alpha;
            this.beta_ = beta;
            this.nu_ = nu;
            this.rho_ = rho;
            this.alphaIsFixed_ = false;
            this.betaIsFixed_ = false;
            this.nuIsFixed_ = false;
            this.rhoIsFixed_ = false;
            this.weights_ = new Array(0);
            this.error_ = Double.MAX_VALUE;
            this.maxError_ = Double.MAX_VALUE;
            this.SABREndCriteria_ = EndCriteria.Type.None;
            QL.require(t > 0.0, "expiry time must be positive: " + t + " not allowed");
            if (!Double.isNaN(this.alpha_)) {
                this.alphaIsFixed_ = alphaIsFixed;
            } else {
                this.alpha_ = Math.sqrt(0.2);
            }
            if (!Double.isNaN(this.beta_)) {
                this.betaIsFixed_ = betaIsFixed;
            } else {
                this.beta_ = 0.5;
            }
            if (!Double.isNaN(this.nu_)) {
                this.nuIsFixed_ = nuIsFixed;
            } else {
                this.nu_ = Math.sqrt(0.4);
            }
            if (!Double.isNaN(this.rho_)) {
                this.rhoIsFixed_ = rhoIsFixed;
            } else {
                this.rho_ = 0.0;
            }
            new Sabr().validateSabrParameters(this.alpha_, this.beta_, this.nu_, this.rho_);
        }
    }
}

