/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import org.jquantlib.math.interpolations.AbstractInterpolation;
import org.jquantlib.math.matrixutilities.Array;

public class ForwardFlatInterpolation
extends AbstractInterpolation {
    public ForwardFlatInterpolation(Array vx, Array vy) {
        this.impl = new ForwardFlatInterpolationImpl(vx, vy);
        this.impl.update();
    }

    private class ForwardFlatInterpolationImpl
    extends AbstractInterpolation.Impl {
        private final Array vp;
        private final int n;

        protected ForwardFlatInterpolationImpl(Array vx, Array vy) {
            super(vx, vy);
            this.n = vx.size();
            this.vp = new Array(this.n);
        }

        @Override
        public void update() {
            this.vp.set(0, 0.0);
            for (int i = 1; i < this.vx.size(); ++i) {
                double dx = this.vx.get(i) - this.vx.get(i - 1);
                this.vp.set(i, this.vp.get(i - 1) + dx * this.vy.get(i - 1));
            }
        }

        @Override
        public double op(double x) {
            if (x >= this.vx.get(this.n - 1)) {
                return this.vy.get(this.n - 1);
            }
            int i = this.locate(x);
            return this.vy.get(i);
        }

        @Override
        public double primitive(double x) {
            int i = this.locate(x);
            double dx = x - this.vx.get(i);
            return this.vp.get(i) + dx * this.vy.get(i);
        }

        @Override
        public double derivative(double x) {
            return 0.0;
        }

        @Override
        public double secondDerivative(double x) {
            return 0.0;
        }
    }
}

