/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import java.util.Arrays;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.interpolations.AbstractInterpolation;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.finitedifferences.TridiagonalOperator;

public class CubicInterpolation
extends AbstractInterpolation {
    public CubicInterpolation(Array vx, Array vy, DerivativeApprox da, boolean monotonic, BoundaryCondition leftCondition, double leftConditionValue, BoundaryCondition rightCondition, double rightConditionValue) {
        this.impl = new CubicInterpolationImpl(vx, vy, da, monotonic, leftCondition, leftConditionValue, rightCondition, rightConditionValue);
        this.impl.update();
    }

    public Array aCoefficients() {
        return new Array(((CubicInterpolationImpl)this.impl).va_);
    }

    public Array bCoefficients() {
        return new Array(((CubicInterpolationImpl)this.impl).vb_);
    }

    public Array cCoefficients() {
        return new Array(((CubicInterpolationImpl)this.impl).vc_);
    }

    public boolean[] monotonicityAdjustments() {
        return (boolean[])((CubicInterpolationImpl)this.impl).ma_.clone();
    }

    private class CubicInterpolationImpl
    extends AbstractInterpolation.Impl {
        private final DerivativeApprox da;
        private final boolean monotonic;
        private final BoundaryCondition leftType;
        private final BoundaryCondition rightType;
        private final double leftValue;
        private final double rightValue;
        private final double[] vx_;
        private final double[] vy_;
        private final double[] vp_;
        private final double[] va_;
        private final double[] vb_;
        private final double[] vc_;
        private final boolean[] ma_;
        private final int n;

        protected CubicInterpolationImpl(Array x, Array y, DerivativeApprox da, boolean monotonic, BoundaryCondition leftCondition, double leftConditionValue, BoundaryCondition rightCondition, double rightConditionValue) {
            super(x, y);
            this.vx_ = x.$;
            this.vy_ = y.$;
            this.n = this.vx_.length;
            this.vp_ = new double[this.n - 1];
            this.va_ = new double[this.n - 1];
            this.vb_ = new double[this.n - 1];
            this.vc_ = new double[this.n - 1];
            this.ma_ = new boolean[this.n];
            this.da = da;
            this.monotonic = monotonic;
            this.leftType = leftCondition;
            this.rightType = rightCondition;
            this.leftValue = leftConditionValue;
            this.rightValue = rightConditionValue;
        }

        @Override
        public void update() {
            int i;
            int i2;
            double[] dx = new double[this.n - 1];
            double[] S = new double[this.n - 1];
            double[] tmp = new double[this.n];
            for (i2 = 0; i2 < this.n - 1; ++i2) {
                dx[i2] = this.vx_[i2 + 1] - this.vx_[i2];
                S[i2] = (this.vy_[i2 + 1] - this.vy_[i2]) / dx[i2];
            }
            if (this.da == DerivativeApprox.Spline) {
                TridiagonalOperator L = new TridiagonalOperator(this.n);
                for (int i3 = 1; i3 < this.n - 1; ++i3) {
                    L.setMidRow(i3, dx[i3], 2.0 * (dx[i3] + dx[i3 - 1]), dx[i3 - 1]);
                    tmp[i3] = 3.0 * (dx[i3] * S[i3 - 1] + dx[i3 - 1] * S[i3]);
                }
                switch (this.leftType) {
                    case NotAKnot: {
                        L.setFirstRow(dx[1] * (dx[1] + dx[0]), (dx[0] + dx[1]) * (dx[0] + dx[1]));
                        tmp[0] = S[0] * dx[1] * (2.0 * dx[1] + 3.0 * dx[0]) + S[1] * dx[0] * dx[0];
                        break;
                    }
                    case FirstDerivative: {
                        L.setFirstRow(1.0, 0.0);
                        tmp[0] = this.leftValue;
                        break;
                    }
                    case SecondDerivative: {
                        L.setFirstRow(2.0, 1.0);
                        tmp[0] = 3.0 * S[0] - this.leftValue * dx[0] / 2.0;
                        break;
                    }
                    case Periodic: 
                    case Lagrange: {
                        throw new LibraryException("this end condition is not implemented yet");
                    }
                    default: {
                        throw new LibraryException("unknown end condition");
                    }
                }
                switch (this.rightType) {
                    case NotAKnot: {
                        L.setLastRow(-(dx[this.n - 2] + dx[this.n - 3]) * (dx[this.n - 2] + dx[this.n - 3]), -dx[this.n - 3] * (dx[this.n - 3] + dx[this.n - 2]));
                        tmp[this.n - 1] = -S[this.n - 3] * dx[this.n - 2] * dx[this.n - 2] - S[this.n - 2] * dx[this.n - 3] * (3.0 * dx[this.n - 2] + 2.0 * dx[this.n - 3]);
                        break;
                    }
                    case FirstDerivative: {
                        L.setLastRow(0.0, 1.0);
                        tmp[this.n - 1] = this.rightValue;
                        break;
                    }
                    case SecondDerivative: {
                        L.setLastRow(1.0, 2.0);
                        tmp[this.n - 1] = 3.0 * S[this.n - 2] + this.rightValue * dx[this.n - 2] / 2.0;
                        break;
                    }
                    case Periodic: 
                    case Lagrange: {
                        throw new LibraryException("this end condition is not implemented yet");
                    }
                    default: {
                        throw new LibraryException("unknown end condition");
                    }
                }
                tmp = L.solveFor(tmp);
            } else if (this.n == 2) {
                tmp[0] = tmp[1] = S[0];
            } else {
                switch (this.da) {
                    case FourthOrder: {
                        throw new LibraryException("FourthOrder not implemented yet");
                    }
                    case Parabolic: {
                        throw new LibraryException("Parabolic not implemented yet");
                    }
                    case ModifiedParabolic: {
                        throw new LibraryException("ModifiedParabolic not implemented yet");
                    }
                    case FritschButland: {
                        throw new LibraryException("FritschButland not implemented yet");
                    }
                    case Akima: {
                        throw new LibraryException("Akima not implemented yet");
                    }
                    case Kruger: {
                        for (i2 = 1; i2 < this.n - 1; ++i2) {
                            tmp[i2] = S[i2 - 1] * S[i2] < 0.0 ? 0.0 : 2.0 / (1.0 / S[i2 - 1] + 1.0 / S[i2]);
                        }
                        tmp[0] = (3.0 * S[0] - tmp[1]) / 2.0;
                        tmp[this.n - 1] = (3.0 * S[this.n - 2] - tmp[this.n - 2]) / 2.0;
                        break;
                    }
                    default: {
                        throw new LibraryException("unknown scheme");
                    }
                }
            }
            Arrays.fill(this.ma_, false);
            if (this.monotonic) {
                for (int i4 = 0; i4 < this.n; ++i4) {
                    double pu;
                    double pd;
                    double correction;
                    if (i4 == 0) {
                        correction = tmp[i4] * S[0] > 0.0 ? tmp[i4] / Math.abs(tmp[i4]) * Math.min(Math.abs(tmp[i4]), Math.abs(3.0 * S[0])) : 0.0;
                        if (Closeness.isClose(correction, tmp[i4])) continue;
                        tmp[i4] = correction;
                        this.ma_[i4] = true;
                        continue;
                    }
                    if (i4 == this.n - 1) {
                        correction = tmp[i4] * S[this.n - 2] > 0.0 ? tmp[i4] / Math.abs(tmp[i4]) * Math.min(Math.abs(tmp[i4]), Math.abs(3.0 * S[this.n - 2])) : 0.0;
                        if (Closeness.isClose(correction, tmp[i4])) continue;
                        tmp[i4] = correction;
                        this.ma_[i4] = true;
                        continue;
                    }
                    double pm = (S[i4 - 1] * dx[i4] + S[i4] * dx[i4 - 1]) / (dx[i4 - 1] + dx[i4]);
                    double M = 3.0 * Math.min(Math.min(Math.abs(S[i4 - 1]), Math.abs(S[i4])), Math.abs(pm));
                    if (i4 > 1 && (S[i4 - 1] - S[i4 - 2]) * (S[i4] - S[i4 - 1]) > 0.0 && pm * (pd = (S[i4 - 1] * (2.0 * dx[i4 - 1] + dx[i4 - 2]) - S[i4 - 2] * dx[i4 - 1]) / (dx[i4 - 2] + dx[i4 - 1])) > 0.0 && pm * (S[i4 - 1] - S[i4 - 2]) > 0.0) {
                        M = Math.max(M, 1.5 * Math.min(Math.abs(pm), Math.abs(pd)));
                    }
                    if (i4 < this.n - 2 && (S[i4] - S[i4 - 1]) * (S[i4 + 1] - S[i4]) > 0.0 && pm * (pu = (S[i4] * (2.0 * dx[i4] + dx[i4 + 1]) - S[i4 + 1] * dx[i4]) / (dx[i4] + dx[i4 + 1])) > 0.0 && -pm * (S[i4] - S[i4 - 1]) > 0.0) {
                        M = Math.max(M, 1.5 * Math.min(Math.abs(pm), Math.abs(pu)));
                    }
                    if (Closeness.isClose(correction = tmp[i4] * pm > 0.0 ? tmp[i4] / Math.abs(tmp[i4]) * Math.min(Math.abs(tmp[i4]), M) : 0.0, tmp[i4])) continue;
                    tmp[i4] = correction;
                    this.ma_[i4] = true;
                }
            }
            for (i = 0; i < this.n - 1; ++i) {
                this.va_[i] = tmp[i];
                this.vb_[i] = (3.0 * S[i] - tmp[i + 1] - 2.0 * tmp[i]) / dx[i];
                this.vc_[i] = (tmp[i + 1] + tmp[i] - 2.0 * S[i]) / (dx[i] * dx[i]);
            }
            this.vp_[0] = 0.0;
            for (i = 1; i < this.n - 1; ++i) {
                this.vp_[i] = this.vp_[i - 1] + dx[i - 1] * (this.vy_[i - 1] + dx[i - 1] * (this.va_[i - 1] / 2.0 + dx[i - 1] * (this.vb_[i - 1] / 3.0 + dx[i - 1] * this.vc_[i - 1] / 4.0)));
            }
        }

        @Override
        public double op(double val) {
            int j = this.locate(val);
            double dx = val - this.vx_[j];
            return this.vy_[j] + dx * (this.va_[j] + dx * (this.vb_[j] + dx * this.vc_[j]));
        }

        @Override
        public double primitive(double val) {
            int j = this.locate(val);
            double dx = val - this.vx_[j];
            return this.vp_[j] + dx * (this.vy_[j] + dx * (this.va_[j] / 2.0 + dx * (this.vb_[j] / 3.0 + dx * this.vc_[j] / 4.0)));
        }

        @Override
        public double derivative(double x) {
            int j = this.locate(x);
            double dx = x - this.vx_[j];
            return this.va_[j] + (2.0 * this.vb_[j] + 3.0 * this.vc_[j] * dx) * dx;
        }

        @Override
        public double secondDerivative(double val) {
            int j = this.locate(val);
            double dx = val - this.vx_[j];
            return 2.0 * this.vb_[j] + 6.0 * this.vc_[j] * dx;
        }
    }

    public static enum BoundaryCondition {
        NotAKnot,
        FirstDerivative,
        SecondDerivative,
        Periodic,
        Lagrange;

    }

    public static enum DerivativeApprox {
        Spline,
        FourthOrder,
        Parabolic,
        ModifiedParabolic,
        FritschButland,
        Akima,
        Kruger;

    }
}

