/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import org.jquantlib.math.interpolations.AbstractInterpolation2D;
import org.jquantlib.math.interpolations.CubicInterpolation;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;

public class BicubicSplineInterpolation
extends AbstractInterpolation2D {
    public BicubicSplineInterpolation(Array vx, Array vy, Matrix mz) {
        this.impl_ = new BicubicSplineImpl(vx, vy, mz);
    }

    private class BicubicSplineImpl
    extends AbstractInterpolation2D.Impl {
        private Interpolation[] splines_;

        public BicubicSplineImpl(Array vx, Array vy, Matrix mz) {
            super(vx, vy, mz);
            this.calculate();
        }

        @Override
        public void calculate() {
            this.splines_ = new Interpolation[this.mz.rows()];
            for (int i = 0; i < this.mz.rows(); ++i) {
                this.splines_[i] = new CubicInterpolation(this.vx, this.mz.rangeRow(i), CubicInterpolation.DerivativeApprox.Spline, false, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0);
            }
        }

        @Override
        public double op(double x, double y) {
            double[] section = new double[this.splines_.length];
            for (int i = 0; i < this.splines_.length; ++i) {
                section[i] = this.splines_[i].op(x, true);
            }
            CubicInterpolation spline = new CubicInterpolation(this.vy, new Array(section), CubicInterpolation.DerivativeApprox.Spline, false, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0);
            return spline.op(y, true);
        }
    }
}

