/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.integrals;

import org.jquantlib.QL;
import org.jquantlib.math.Ops;
import org.jquantlib.math.integrals.Integrator;

public class SegmentIntegral
extends Integrator {
    private final int intervals;

    public SegmentIntegral(int intervals) {
        super(1.0, 1);
        QL.require(intervals >= 1, "at least 1 interval needed");
        this.intervals = intervals;
    }

    @Override
    public final double integrate(Ops.DoubleOp f, double a, double b) {
        double dx = (b - a) / (double)this.numberOfEvaluations();
        double sum = 0.5 * (f.op(a) + f.op(b));
        double end = b - 0.5 * dx;
        for (double x = a + dx; x < end; x += dx) {
            sum += f.op(x);
        }
        return sum * dx;
    }

    @Override
    public final int numberOfEvaluations() {
        return this.intervals;
    }
}

