/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.integrals;

import org.jquantlib.QL;
import org.jquantlib.math.Constants;
import org.jquantlib.math.Ops;
import org.jquantlib.math.integrals.Integrator;

@Deprecated
public class GaussKronrodPatterson
extends Integrator {
    private double relativeAccuracy;
    private static final double[] x1 = new double[]{0.9739065285171717, 0.8650633666889845, 0.6794095682990244, 0.4333953941292472, 0.14887433898163122};
    private static final double[] w10 = new double[]{0.06667134430868814, 0.1494513491505806, 0.21908636251598204, 0.26926671930999635, 0.29552422471475287};
    private static final double[] x2 = new double[]{0.9956571630258081, 0.9301574913557082, 0.7808177265864169, 0.5627571346686047, 0.2943928627014602};
    private static final double[] w21a = new double[]{0.032558162307964725, 0.07503967481091996, 0.10938715880229764, 0.13470921731147334, 0.14773910490133849};
    private static final double[] w21b = new double[]{0.011694638867371874, 0.054755896574351995, 0.0931254545836976, 0.12349197626206584, 0.14277593857706009, 0.1494455540029169};
    private static final double[] x3 = new double[]{0.999333360901932, 0.9874334029080889, 0.9548079348142663, 0.9001486957483283, 0.8251983149831141, 0.732148388989305, 0.6228479705377252, 0.4994795740710565, 0.36490166134658075, 0.2222549197766013, 0.07465061746138332};
    private static final double[] w43a = new double[]{0.016296734289666565, 0.0375228761208695, 0.05469490205825544, 0.06735541460947808, 0.07387019963239395, 0.005768556059769796, 0.027371890593248842, 0.04656082691042883, 0.06174499520144257, 0.07138726726869339};
    private static final double[] w43b = new double[]{0.001844477640212414, 0.010798689585891651, 0.021895363867795427, 0.032597463975345686, 0.04216313793519181, 0.050741939600184575, 0.05837939554261925, 0.06474640495144589, 0.06956619791235648, 0.07282444147183322, 0.07450775101417512, 0.07472214751740301};
    private static final double[] x4 = new double[]{0.9999029772627293, 0.9979898959866788, 0.9921754978606873, 0.9813581635727128, 0.9650576238583847, 0.9431676131336706, 0.9158064146855072, 0.8832216577713164, 0.8457107484624157, 0.8035576580352309, 0.7570057306854956, 0.7062732097873218, 0.6515894665011779, 0.5932233740579611, 0.531493605970832, 0.46676362304202285, 0.3994248478592188, 0.3298748771061883, 0.25850355920216156, 0.18569539656834666, 0.11184221317990747, 0.03735212339461987};
    private static final double[] w87a = new double[]{0.008148377384149173, 0.018761438201562824, 0.027347451050052287, 0.03367770731163793, 0.036935099820427905, 0.0028848724302115306, 0.013685946022712702, 0.02328041350288831, 0.03087249761171336, 0.03569363363941877, 9.152833452022414E-4, 0.005399280219300471, 0.01094767960111893, 0.016298731696787336, 0.021081568889203834, 0.025370969769253827, 0.029189697756475754, 0.03237320246720279, 0.034783098950365146, 0.03641222073135179, 0.037253875503047706};
    private static final double[] w87b = new double[]{2.7414556376207234E-4, 0.0018071241550579428, 0.0040968692827591646, 0.006758290051847379, 0.009549957672201646, 0.012329447652244854, 0.015010447346388952, 0.01754896798624319, 0.019938037786440887, 0.022194935961012286, 0.024339147126000805, 0.026374505414839208, 0.0282869107887712, 0.030052581128092695, 0.03164675137143993, 0.033050413419978504, 0.034255099704226064, 0.03526241266015668, 0.0360769896228887, 0.03669860449845609, 0.037120549269832576, 0.03733422875193504, 0.037361073762679026};

    public GaussKronrodPatterson(double absoluteAccuracy, int maxEvaluations, double relativeAccuracy) {
        super(absoluteAccuracy, maxEvaluations);
        this.relativeAccuracy = relativeAccuracy;
    }

    public GaussKronrodPatterson(double relativeAccuracy, double absoluteAccuracy) {
        this(absoluteAccuracy, 100, relativeAccuracy);
    }

    public GaussKronrodPatterson() {
        this(1.0E-6, 1.0);
    }

    public final double getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    public final void setRelativeAccuracy(double relativeAccuracy) {
        this.relativeAccuracy = relativeAccuracy;
    }

    @Override
    protected double integrate(Ops.DoubleOp f, double a, double b) {
        double abscissa;
        int k;
        double fval;
        double fval2;
        double fval1;
        double abscissa2;
        int k2;
        double[] fv1 = new double[5];
        double[] fv2 = new double[5];
        double[] fv3 = new double[5];
        double[] fv4 = new double[5];
        double[] savfun = new double[21];
        QL.require(a < b, "b must be greater than a");
        double halfLength = 0.5 * (b - a);
        double center = 0.5 * (b + a);
        double fCenter = f.op(center);
        double res10 = 0.0;
        double res21 = w21b[5] * fCenter;
        double resAbs = w21b[5] * Math.abs(fCenter);
        for (k2 = 0; k2 < 5; ++k2) {
            abscissa2 = halfLength * x1[k2];
            fval1 = f.op(center + abscissa2);
            fval2 = f.op(center - abscissa2);
            fval = fval1 + fval2;
            res10 += w10[k2] * fval;
            res21 += w21a[k2] * fval;
            resAbs += w21a[k2] * (Math.abs(fval1) + Math.abs(fval2));
            savfun[k2] = fval;
            fv1[k2] = fval1;
            fv2[k2] = fval2;
        }
        for (k2 = 0; k2 < 5; ++k2) {
            abscissa2 = halfLength * x2[k2];
            fval1 = f.op(center + abscissa2);
            fval2 = f.op(center - abscissa2);
            fval = fval1 + fval2;
            res21 += w21b[k2] * fval;
            resAbs += w21b[k2] * (Math.abs(fval1) + Math.abs(fval2));
            savfun[k2 + 5] = fval;
            fv3[k2] = fval1;
            fv4[k2] = fval2;
        }
        double result = res21 * halfLength;
        resAbs *= halfLength;
        double mean = 0.5 * res21;
        double resasc = w21b[5] * Math.abs(fCenter - mean);
        for (k = 0; k < 5; ++k) {
            resasc += w21a[k] * (Math.abs(fv1[k] - mean) + Math.abs(fv2[k] - mean)) + w21b[k] * (Math.abs(fv3[k] - mean) + Math.abs(fv4[k] - mean));
        }
        double err = this.rescaleError((res21 - res10) * halfLength, resAbs, resasc);
        resasc *= halfLength;
        if (err < this.absoluteAccuracy() || err < this.getRelativeAccuracy() * Math.abs(result)) {
            this.setAbsoluteError(err);
            this.setNumberOfEvaluations(21);
            return result;
        }
        double res43 = w43b[11] * fCenter;
        for (k = 0; k < 10; ++k) {
            res43 += savfun[k] * w43a[k];
        }
        for (k = 0; k < 11; ++k) {
            abscissa = halfLength * x3[k];
            double fval3 = f.op(center + abscissa) + f.op(center - abscissa);
            res43 += fval3 * w43b[k];
            savfun[k + 10] = fval3;
        }
        result = res43 * halfLength;
        err = this.rescaleError((res43 - res21) * halfLength, resAbs, resasc);
        if (err < this.absoluteAccuracy() || err < this.getRelativeAccuracy() * Math.abs(result)) {
            this.setAbsoluteError(err);
            this.setNumberOfEvaluations(43);
            return result;
        }
        double res87 = w87b[22] * fCenter;
        for (k = 0; k < 21; ++k) {
            res87 += savfun[k] * w87a[k];
        }
        for (k = 0; k < 22; ++k) {
            abscissa = halfLength * x4[k];
            res87 += w87b[k] * (f.op(center + abscissa) + f.op(center - abscissa));
        }
        result = res87 * halfLength;
        err = this.rescaleError((res87 - res43) * halfLength, resAbs, resasc);
        this.setAbsoluteError(err);
        this.setNumberOfEvaluations(87);
        return result;
    }

    private double rescaleError(double err, double resultAbs, double resultAsc) {
        double min_err;
        err = Math.abs(err);
        if (resultAsc != 0.0 && err != 0.0) {
            double scale = Math.pow(200.0 * err / resultAsc, 1.5);
            err = scale < 1.0 ? resultAsc * scale : resultAsc;
        }
        if (resultAbs > Double.MIN_VALUE / (50.0 * Constants.QL_EPSILON) && (min_err = 50.0 * Constants.QL_EPSILON * resultAbs) > err) {
            err = min_err;
        }
        return err;
    }
}

