/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.math.distributions.Derivative;

public class NormalDistribution
implements Derivative {
    protected double average;
    protected double sigma;
    private final double normalizationFactor;
    private final double denominator;
    private final double denormalizationFactor;

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    public NormalDistribution(double average) {
        this(average, 1.0);
    }

    public NormalDistribution(double average, double sigma) {
        QL.require(sigma > 0.0, "sigma must be greater than 0.0");
        this.average = average;
        this.sigma = sigma;
        this.normalizationFactor = 0.3989422804014327 / sigma;
        this.denormalizationFactor = sigma * sigma;
        this.denominator = 2.0 * this.denormalizationFactor;
    }

    @Override
    public double op(double x) {
        double exponent = -0.5 * x * x;
        if (exponent <= -690.0) {
            return 0.0;
        }
        return 0.3989422804014327 * Math.exp(exponent);
    }

    @Override
    public double derivative(double x) {
        return this.op(x) * (this.average - x) / this.denormalizationFactor;
    }
}

