/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.math.Constants;
import org.jquantlib.math.Ops;
import org.jquantlib.math.distributions.GammaFunction;

public class NonCentralChiSquaredDistribution
implements Ops.DoubleOp {
    private static final String FAILED_TO_CONVERGE = "failed to converge";
    private final double df;
    private final double ncp;
    private final GammaFunction gammaFunction_ = new GammaFunction();

    public NonCentralChiSquaredDistribution(double df, double ncp) {
        this.df = df;
        this.ncp = ncp;
    }

    @Override
    public double op(double x) {
        double f_x_2n;
        double u;
        if (x <= 0.0) {
            return 0.0;
        }
        double errmax = 1.0E-12;
        int itrmax = 10000;
        double lam = 0.5 * this.ncp;
        double v = u = Math.exp(-lam);
        double x2 = 0.5 * x;
        double f2 = 0.5 * this.df;
        double t = 0.0;
        t = f2 * Constants.QL_EPSILON > 0.125 && Math.abs(x2 - f2) < Math.sqrt(Constants.QL_EPSILON) * f2 ? Math.exp((1.0 - t) * (2.0 - t / (f2 + 1.0))) / Math.sqrt(Math.PI * 2 * (f2 + 1.0)) : Math.exp(f2 * Math.log(x2) - x2 - this.gammaFunction_.logValue(f2 + 1.0));
        double ans = v * t;
        int n = 1;
        double f_2n = this.df + 2.0;
        for (f_x_2n = this.df + 2.0 - x; f_x_2n <= 0.0; f_x_2n += 2.0) {
            ans += (v += (u *= lam / (double)n)) * (t *= x / f_2n);
            ++n;
            f_2n += 2.0;
        }
        while (n <= 10000) {
            double bound = t * x / f_x_2n;
            if (bound > 1.0E-12) {
                ans += (v += (u *= lam / (double)n)) * (t *= x / f_2n);
                ++n;
                f_2n += 2.0;
                f_x_2n += 2.0;
                continue;
            }
            return ans;
        }
        throw new ArithmeticException(FAILED_TO_CONVERGE);
    }
}

