/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.math.Constants;
import org.jquantlib.math.distributions.GammaFunction;

public class IncompleteGamma {
    private static final String ACCURACY_NOT_REACHED = "accuracy not reached";

    public double incompleteGammaFunction(double a, double x, double accuracy, int maxIteration) {
        QL.require(a > 0.0, "non-positive a is not allowed");
        QL.require(x >= 0.0, "negative x non allowed");
        if (x < a + 1.0) {
            return this.incompleteGammaFunctionSeriesRepr(a, x, accuracy, maxIteration);
        }
        return 1.0 - this.incompleteGammaFunctionContinuedFractionRepr(a, x, accuracy, maxIteration);
    }

    private double incompleteGammaFunctionSeriesRepr(double a, double x, double accuracy, int maxIteration) {
        double del;
        if (x == 0.0) {
            return 0.0;
        }
        double gln = new GammaFunction().logValue(a);
        double ap = a;
        double sum = del = 1.0 / a;
        for (int n = 1; n <= maxIteration; ++n) {
            sum += (del *= x / (ap += 1.0));
            if (!(Math.abs(del) < Math.abs(sum) * accuracy)) continue;
            return sum * Math.exp(-x + a * Math.log(x) - gln);
        }
        throw new ArithmeticException(ACCURACY_NOT_REACHED);
    }

    public double incompleteGammaFunctionContinuedFractionRepr(double a, double x, double accuracy, int maxIteration) {
        double d;
        double gln = new GammaFunction().logValue(a);
        double b = x + 1.0 - a;
        double c = 1.0 / Constants.QL_EPSILON;
        double h = d = 1.0 / b;
        for (int i = 1; i <= maxIteration; ++i) {
            double an = (double)(-i) * ((double)i - a);
            if (Math.abs(d = an * d + (b += 2.0)) < Constants.QL_EPSILON) {
                d = Constants.QL_EPSILON;
            }
            if (Math.abs(c = b + an / c) < Constants.QL_EPSILON) {
                c = Constants.QL_EPSILON;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (!(Math.abs(del - 1.0) < accuracy)) continue;
            return Math.exp(-x + a * Math.log(x) - gln) * h;
        }
        throw new ArithmeticException(ACCURACY_NOT_REACHED);
    }
}

